/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.core.invoker;

import java.lang.reflect.InvocationTargetException;
import org.craftsmenlabs.gareth.api.exception.GarethInvocationException;
import org.craftsmenlabs.gareth.api.invoker.MethodDescriptor;
import org.craftsmenlabs.gareth.api.invoker.MethodInvoker;
import org.craftsmenlabs.gareth.api.storage.Storage;
import org.craftsmenlabs.gareth.core.reflection.ReflectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodInvokerImpl
implements MethodInvoker {
    private static final Logger logger = LoggerFactory.getLogger(MethodInvokerImpl.class);
    private final ReflectionHelper reflectionHelper;

    public MethodInvokerImpl(ReflectionHelper reflectionHelper) {
        this.reflectionHelper = reflectionHelper;
    }

    @Override
    public void invoke(MethodDescriptor methodDescriptor) throws GarethInvocationException {
        this.invoke(methodDescriptor, null);
    }

    @Override
    public void invoke(MethodDescriptor methodDescriptor, Storage storage) throws GarethInvocationException {
        try {
            logger.trace("Invoking method %s", (Object)methodDescriptor.getMethod().getName());
            Object declaringClassInstance = this.reflectionHelper.getInstanceForClass(methodDescriptor.getMethod().getDeclaringClass());
            if (methodDescriptor.hasStorage()) {
                methodDescriptor.getMethod().invoke(declaringClassInstance, storage);
            } else {
                methodDescriptor.getMethod().invoke(declaringClassInstance, new Object[0]);
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new GarethInvocationException(e);
        }
    }
}

