/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.core.persist;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.craftsmenlabs.gareth.api.ExperimentEngine;
import org.craftsmenlabs.gareth.api.context.ExperimentContext;
import org.craftsmenlabs.gareth.api.exception.GarethStateReadException;
import org.craftsmenlabs.gareth.api.exception.GarethStateWriteException;
import org.craftsmenlabs.gareth.api.persist.ExperimentEnginePersistence;
import org.craftsmenlabs.gareth.core.persist.ExperimentContextData;
import org.craftsmenlabs.gareth.core.persist.UnknownExperimentContextException;
import org.craftsmenlabs.gareth.core.util.ExperimentContextHashGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemExperimentEnginePersistence
implements ExperimentEnginePersistence {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemExperimentEnginePersistence.class);
    private final File stateFile;

    private FileSystemExperimentEnginePersistence(Builder builder) {
        this.stateFile = builder.stateFile;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void persist(ExperimentEngine experimentEngine) throws GarethStateWriteException {
        ArrayList data = new ArrayList();
        experimentEngine.getExperimentContexts().forEach(experimentContext -> data.add(this.buildExperimentContextData((ExperimentContext)experimentContext)));
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(this.stateFile);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(data);
        }
        catch (FileNotFoundException e) {
            try {
                LOG.error("File cannot be found", e);
                throw new GarethStateWriteException(e);
                catch (IOException e2) {
                    LOG.error("Error while writing experiment engine data", e2);
                    throw new GarethStateWriteException(e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(oos);
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(oos);
        IOUtils.closeQuietly(fos);
    }

    @Override
    public void restore(ExperimentEngine experimentEngine) throws GarethStateReadException {
        List<ExperimentContextData> experimentContextDataList = this.readExperimentContextDataFromFile();
        experimentEngine.getExperimentContexts().forEach(experimentContext -> {
            try {
                ExperimentContextData experimentContextData = this.findExperimentContextDataForHash(experimentContextDataList, ExperimentContextHashGenerator.generateHash(experimentContext));
                this.writeExperimentContextState((ExperimentContext)experimentContext, experimentContextData);
            }
            catch (UnknownExperimentContextException e) {
                LOG.debug("No experiment context data found.", e);
            }
        });
    }

    private void writeExperimentContextState(ExperimentContext experimentContext, ExperimentContextData experimentContextData) {
        experimentContext.setBaselineState(experimentContextData.getBaselineState());
        experimentContext.setAssumeState(experimentContextData.getAssumeState());
        experimentContext.setSuccessState(experimentContextData.getSuccessState());
        experimentContext.setFailureState(experimentContext.getFailureState());
        experimentContext.setBaselineRun(experimentContextData.getBaselineRun());
        experimentContext.setAssumeRun(experimentContextData.getAssumeRun());
        experimentContext.setSuccessRun(experimentContextData.getSuccessRun());
        experimentContext.setFailureRun(experimentContextData.getFailureRun());
    }

    private ExperimentContextData findExperimentContextDataForHash(List<ExperimentContextData> experimentContexts, String hash) {
        return experimentContexts.parallelStream().filter(experimentContextData -> experimentContextData.getHash().equals(hash)).findFirst().orElseThrow(() -> new UnknownExperimentContextException(String.format("Cannot find experiment context data with hash %s", hash)));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<ExperimentContextData> readExperimentContextDataFromFile() throws GarethStateReadException {
        List experimentContextDataList = null;
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            fis = new FileInputStream(this.stateFile);
            ois = new ObjectInputStream(fis);
            experimentContextDataList = (List)ois.readObject();
        }
        catch (ClassNotFoundException e) {
            try {
                LOG.error("Class cannot be found", e);
                throw new GarethStateReadException(e);
                catch (FileNotFoundException e2) {
                    LOG.error("File cannot be found", e2);
                    throw new GarethStateReadException(e2);
                }
                catch (IOException e3) {
                    LOG.error("Exception while reading file", e3);
                    throw new GarethStateReadException(e3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(ois);
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(ois);
        IOUtils.closeQuietly(fis);
        return experimentContextDataList;
    }

    private ExperimentContextData buildExperimentContextData(ExperimentContext experimentContext) {
        ExperimentContextData experimentEngineContextData = new ExperimentContextData();
        experimentEngineContextData.setHash(ExperimentContextHashGenerator.generateHash(experimentContext));
        experimentEngineContextData.setBaselineRun(experimentContext.getBaselineRun());
        experimentEngineContextData.setAssumeRun(experimentContext.getAssumeRun());
        experimentEngineContextData.setSuccessRun(experimentContext.getSuccessRun());
        experimentEngineContextData.setFailureRun(experimentContext.getFailureRun());
        experimentEngineContextData.setBaselineState(experimentContext.getBaselineState());
        experimentEngineContextData.setAssumeState(experimentContext.getAssumeState());
        experimentEngineContextData.setSuccessState(experimentContext.getSuccessState());
        experimentEngineContextData.setFailureState(experimentContext.getFailureState());
        return experimentEngineContextData;
    }

    public static class Builder {
        private static final String STATE_FILENAME = "gareth.state";
        private static final String TMP_DIR = System.getProperty("java.io.tmpdir");
        private File stateFile;

        public Builder setStateFile(File stateFile) {
            this.stateFile = stateFile;
            return this;
        }

        public ExperimentEnginePersistence build() {
            this.setupStateFile();
            return new FileSystemExperimentEnginePersistence(this);
        }

        private void setupStateFile() {
            if (null == this.stateFile) {
                this.stateFile = new File(TMP_DIR, STATE_FILENAME);
            }
            try {
                if (!this.stateFile.exists()) {
                    this.stateFile.createNewFile();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Cannot setup state file %s", this.stateFile.getPath()), e);
            }
        }
    }
}

