/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.core.util;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import org.craftsmenlabs.gareth.api.context.ExperimentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentContextHashGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(ExperimentContextHashGenerator.class);

    public static String generateHash(ExperimentContext experimentContext) {
        byte[] digest = new byte[]{};
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(ExperimentContextHashGenerator.buildExperimentContextHash(experimentContext).getBytes("UTF-8"));
            digest = md.digest();
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            LOG.error("Cannot generate hash for experiment context");
        }
        return String.format("%064x", new BigInteger(1, digest));
    }

    private static String buildExperimentContextHash(ExperimentContext experimentContext) {
        StringBuilder stringBuilder = new StringBuilder("");
        Optional.ofNullable(experimentContext).ifPresent(ec -> {
            stringBuilder.append(ec.getExperimentName());
            stringBuilder.append(ec.getBaselineGlueLine());
            stringBuilder.append(ec.getAssumeGlueLine());
            stringBuilder.append(ec.getTimeGlueLine());
            stringBuilder.append(ec.getSuccessGlueLine());
            stringBuilder.append(ec.getFailureGlueLine());
        });
        return stringBuilder.toString();
    }
}

