/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core;

import com.xeiam.sundial.plugins.AnnotationJobTriggerPlugin;
import org.quartz.QuartzScheduler;
import org.quartz.core.QuartzSchedulerResources;
import org.quartz.core.RAMJobStore;
import org.quartz.core.Scheduler;
import org.quartz.core.SimpleThreadPool;
import org.quartz.core.StandardJobRunShellFactory;
import org.quartz.exceptions.SchedulerException;
import org.quartz.plugins.management.ShutdownHookPlugin;
import org.quartz.plugins.xml.XMLSchedulingDataProcessorPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerFactory {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private QuartzScheduler quartzScheduler = null;
    private int threadPoolSize = 10;
    private String packageName = null;

    public Scheduler getScheduler(int threadPoolSize, String packageName) throws SchedulerException {
        this.threadPoolSize = threadPoolSize;
        this.packageName = packageName;
        return this.getScheduler();
    }

    public Scheduler getScheduler(int threadPoolSize) throws SchedulerException {
        this.threadPoolSize = threadPoolSize;
        return this.getScheduler();
    }

    public Scheduler getScheduler() throws SchedulerException {
        if (this.quartzScheduler != null) {
            return this.quartzScheduler;
        }
        return this.instantiate();
    }

    private Scheduler instantiate() throws SchedulerException {
        SimpleThreadPool threadPool = new SimpleThreadPool();
        threadPool.setThreadCount(this.threadPoolSize);
        RAMJobStore jobstore = new RAMJobStore();
        boolean tpInited = false;
        boolean qsInited = false;
        try {
            StandardJobRunShellFactory jrsf = new StandardJobRunShellFactory();
            QuartzSchedulerResources quartzSchedulerResources = new QuartzSchedulerResources();
            quartzSchedulerResources.setThreadName("Quartz Scheduler Thread");
            quartzSchedulerResources.setJobRunShellFactory(jrsf);
            quartzSchedulerResources.setMakeSchedulerThreadDaemon(false);
            quartzSchedulerResources.setThreadsInheritInitializersClassLoadContext(false);
            quartzSchedulerResources.setBatchTimeWindow(0L);
            quartzSchedulerResources.setMaxBatchSize(1);
            quartzSchedulerResources.setInterruptJobsOnShutdown(true);
            quartzSchedulerResources.setInterruptJobsOnShutdownWithWait(true);
            quartzSchedulerResources.setThreadPool(threadPool);
            threadPool.setThreadNamePrefix("Quartz_Scheduler_Worker");
            threadPool.initialize();
            tpInited = true;
            quartzSchedulerResources.setJobStore(jobstore);
            this.quartzScheduler = new QuartzScheduler(quartzSchedulerResources);
            qsInited = true;
            XMLSchedulingDataProcessorPlugin xmlSchedulingDataProcessorPlugin = new XMLSchedulingDataProcessorPlugin();
            xmlSchedulingDataProcessorPlugin.setFailOnFileNotFound(false);
            xmlSchedulingDataProcessorPlugin.setScanInterval(0L);
            quartzSchedulerResources.addSchedulerPlugin(xmlSchedulingDataProcessorPlugin);
            ShutdownHookPlugin shutdownHookPlugin = new ShutdownHookPlugin();
            quartzSchedulerResources.addSchedulerPlugin(shutdownHookPlugin);
            AnnotationJobTriggerPlugin annotationJobTriggerPlugin = new AnnotationJobTriggerPlugin(this.packageName);
            quartzSchedulerResources.addSchedulerPlugin(annotationJobTriggerPlugin);
            jobstore.initialize(this.quartzScheduler.getSchedulerSignaler());
            jobstore.setThreadPoolSize(threadPool.getPoolSize());
            xmlSchedulingDataProcessorPlugin.initialize("XMLSchedulingDataProcessorPlugin", this.quartzScheduler);
            shutdownHookPlugin.initialize("ShutdownHookPlugin", this.quartzScheduler);
            annotationJobTriggerPlugin.initialize("AnnotationJobTriggerPlugin", this.quartzScheduler);
            jrsf.initialize(this.quartzScheduler);
            this.quartzScheduler.initialize();
            return this.quartzScheduler;
        }
        catch (SchedulerException e) {
            if (qsInited) {
                this.quartzScheduler.shutdown(false);
            } else if (tpInited) {
                threadPool.shutdown(false);
            }
            throw e;
        }
        catch (RuntimeException re) {
            if (qsInited) {
                this.quartzScheduler.shutdown(false);
            } else if (tpInited) {
                threadPool.shutdown(false);
            }
            throw re;
        }
        catch (Error re) {
            if (qsInited) {
                this.quartzScheduler.shutdown(false);
            } else if (tpInited) {
                threadPool.shutdown(false);
            }
            throw re;
        }
    }
}

