/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core;

import org.quartz.QuartzScheduler;
import org.quartz.core.QuartzSchedulerThread;
import org.quartz.core.SchedulerSignaler;
import org.quartz.exceptions.SchedulerException;
import org.quartz.triggers.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerSignalerImpl
implements SchedulerSignaler {
    private Logger logger = LoggerFactory.getLogger(SchedulerSignalerImpl.class);
    private QuartzScheduler quartzScheduler;
    private QuartzSchedulerThread quartzSchedulerThread;

    public SchedulerSignalerImpl(QuartzScheduler quartzScheduler, QuartzSchedulerThread quartzSchedulerThread) {
        this.quartzScheduler = quartzScheduler;
        this.quartzSchedulerThread = quartzSchedulerThread;
        this.logger.info("Initialized Scheduler Signaler of type: " + this.getClass());
    }

    @Override
    public void notifyTriggerListenersMisfired(Trigger trigger) {
        try {
            this.quartzScheduler.notifyTriggerListenersMisfired(trigger);
        }
        catch (SchedulerException se) {
            this.logger.error("Error notifying listeners of trigger misfire.", se);
            this.quartzScheduler.notifySchedulerListenersError("Error notifying listeners of trigger misfire.", se);
        }
    }

    @Override
    public void notifySchedulerListenersFinalized(Trigger trigger) {
        this.quartzScheduler.notifySchedulerListenersFinalized(trigger);
    }

    @Override
    public void signalSchedulingChange(long candidateNewNextFireTime) {
        this.quartzSchedulerThread.signalSchedulingChange(candidateNewNextFireTime);
    }

    @Override
    public void notifySchedulerListenersJobDeleted(String jobKey) {
        this.quartzScheduler.notifySchedulerListenersJobDeleted(jobKey);
    }
}

