/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.core.context;

import java.time.LocalDateTime;
import org.craftsmenlabs.gareth.api.context.ExperimentContext;
import org.craftsmenlabs.gareth.api.context.ExperimentPartState;
import org.craftsmenlabs.gareth.api.context.ExperimentRunContext;
import org.craftsmenlabs.gareth.api.storage.Storage;

public class ExperimentRunContextImpl
implements ExperimentRunContext {
    private final ExperimentContext experimentContext;
    private final Storage storage;
    private ExperimentPartState baselineState;
    private ExperimentPartState assumeState;
    private ExperimentPartState successState;
    private ExperimentPartState failureState;
    private LocalDateTime baselineRun;
    private LocalDateTime assumeRun;
    private LocalDateTime successRun;
    private LocalDateTime failureRun;
    private boolean finished;

    private ExperimentRunContextImpl(Builder builder) {
        this.experimentContext = builder.experimentContext;
        this.storage = builder.storage;
        this.baselineState = builder.baselineState;
        this.assumeState = builder.assumeState;
        this.successState = builder.successState;
        this.failureState = builder.failureState;
    }

    @Override
    public String getHash() {
        return this.experimentContext.getHash();
    }

    @Override
    public boolean hasFailures() {
        return null != this.failureRun;
    }

    @Override
    public boolean isRunning() {
        return (null != this.baselineRun || null != this.assumeRun) && null == this.successRun && null == this.failureRun;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    @Override
    public ExperimentContext getExperimentContext() {
        return this.experimentContext;
    }

    @Override
    public Storage getStorage() {
        return this.storage;
    }

    @Override
    public ExperimentPartState getBaselineState() {
        return this.baselineState;
    }

    @Override
    public ExperimentPartState getAssumeState() {
        return this.assumeState;
    }

    @Override
    public ExperimentPartState getSuccessState() {
        return this.successState;
    }

    @Override
    public ExperimentPartState getFailureState() {
        return this.failureState;
    }

    @Override
    public LocalDateTime getBaselineRun() {
        return this.baselineRun;
    }

    @Override
    public LocalDateTime getAssumeRun() {
        return this.assumeRun;
    }

    @Override
    public LocalDateTime getSuccessRun() {
        return this.successRun;
    }

    @Override
    public LocalDateTime getFailureRun() {
        return this.failureRun;
    }

    @Override
    public void setBaselineState(ExperimentPartState baselineState) {
        this.baselineState = baselineState;
    }

    @Override
    public void setAssumeState(ExperimentPartState assumeState) {
        this.assumeState = assumeState;
    }

    @Override
    public void setSuccessState(ExperimentPartState successState) {
        this.successState = successState;
    }

    @Override
    public void setFailureState(ExperimentPartState failureState) {
        this.failureState = failureState;
    }

    @Override
    public void setBaselineRun(LocalDateTime baselineRun) {
        this.baselineRun = baselineRun;
    }

    @Override
    public void setAssumeRun(LocalDateTime assumeRun) {
        this.assumeRun = assumeRun;
    }

    @Override
    public void setSuccessRun(LocalDateTime successRun) {
        this.successRun = successRun;
    }

    @Override
    public void setFailureRun(LocalDateTime failureRun) {
        this.failureRun = failureRun;
    }

    public static class Builder {
        private ExperimentContext experimentContext;
        private Storage storage;
        private ExperimentPartState baselineState = ExperimentPartState.NON_EXISTENT;
        private ExperimentPartState assumeState = ExperimentPartState.NON_EXISTENT;
        private ExperimentPartState successState = ExperimentPartState.NON_EXISTENT;
        private ExperimentPartState failureState = ExperimentPartState.NON_EXISTENT;

        public Builder(ExperimentContext experimentContext, Storage storage) {
            this.experimentContext = experimentContext;
            this.storage = storage;
        }

        public ExperimentRunContext build() {
            if (null == this.experimentContext) {
                throw new IllegalStateException("Cannot build experiment run context without experiment context");
            }
            if (null != this.experimentContext.getBaseline()) {
                this.baselineState = ExperimentPartState.OPEN;
            }
            if (null != this.experimentContext.getAssume()) {
                this.assumeState = ExperimentPartState.OPEN;
            }
            if (null != this.experimentContext.getSuccess()) {
                this.successState = ExperimentPartState.OPEN;
            }
            if (null != this.experimentContext.getFailure()) {
                this.failureState = ExperimentPartState.OPEN;
            }
            return new ExperimentRunContextImpl(this);
        }
    }
}

