/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.core.registry;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.craftsmenlabs.gareth.api.exception.GarethAlreadyKnownDefinitionException;
import org.craftsmenlabs.gareth.api.exception.GarethUnknownDefinitionException;
import org.craftsmenlabs.gareth.api.invoker.MethodDescriptor;
import org.craftsmenlabs.gareth.api.registry.DefinitionRegistry;

public class DefinitionRegistryImpl
implements DefinitionRegistry {
    private final Map<String, MethodDescriptor> baselineDefinitions = new HashMap<String, MethodDescriptor>();
    private final Map<String, MethodDescriptor> assumeDefinitions = new HashMap<String, MethodDescriptor>();
    private final Map<String, MethodDescriptor> successDefinitions = new HashMap<String, MethodDescriptor>();
    private final Map<String, MethodDescriptor> failureDefinitions = new HashMap<String, MethodDescriptor>();
    private final Map<String, Duration> timeDefinitions = new HashMap<String, Duration>();

    @Override
    public MethodDescriptor getMethodDescriptorForBaseline(String glueLine) {
        return this.getDefinition(this.getBaselineDefinitions(), glueLine);
    }

    @Override
    public MethodDescriptor getMethodDescriptorForAssume(String glueLine) {
        return this.getDefinition(this.getAssumeDefinitions(), glueLine);
    }

    @Override
    public MethodDescriptor getMethodDescriptorForSuccess(String glueLine) {
        return this.getDefinition(this.getSuccessDefinitions(), glueLine);
    }

    @Override
    public MethodDescriptor getMethodDescriptorForFailure(String glueLine) {
        return this.getDefinition(this.getFailureDefinitions(), glueLine);
    }

    @Override
    public void addMethodDescriptorForBaseline(String glueLine, MethodDescriptor method) {
        this.addDefinition(this.getBaselineDefinitions(), glueLine, method);
    }

    @Override
    public void addMethodDescriptorForAssume(String glueLine, MethodDescriptor method) {
        this.addDefinition(this.getAssumeDefinitions(), glueLine, method);
    }

    @Override
    public void addMethodDescriptorForSuccess(String glueLine, MethodDescriptor method) {
        this.addDefinition(this.getSuccessDefinitions(), glueLine, method);
    }

    @Override
    public void addMethodDescriptorForFailure(String glueLine, MethodDescriptor method) {
        this.addDefinition(this.getFailureDefinitions(), glueLine, method);
    }

    @Override
    public Duration getDurationForTime(String glueLine) {
        return this.getDefinition(this.getTimeDefinitions(), glueLine);
    }

    @Override
    public void addDurationForTime(String glueLine, Duration duration) {
        this.addDefinition(this.getTimeDefinitions(), glueLine, duration);
    }

    private <T> T getDefinition(Map<String, T> valueMap, String glueLine) {
        return Optional.ofNullable(valueMap.get(glueLine)).orElseThrow(() -> new GarethUnknownDefinitionException(String.format("No definition found for glue line '%s'", glueLine)));
    }

    private <T> void addDefinition(Map<String, T> valueMap, String glueLine, T definition) {
        if (valueMap.containsKey(glueLine)) {
            throw new GarethAlreadyKnownDefinitionException(String.format("Glue line already registered for '%s'", glueLine));
        }
        valueMap.put(glueLine, definition);
    }

    public Map<String, MethodDescriptor> getBaselineDefinitions() {
        return this.baselineDefinitions;
    }

    public Map<String, MethodDescriptor> getAssumeDefinitions() {
        return this.assumeDefinitions;
    }

    public Map<String, MethodDescriptor> getSuccessDefinitions() {
        return this.successDefinitions;
    }

    public Map<String, MethodDescriptor> getFailureDefinitions() {
        return this.failureDefinitions;
    }

    public Map<String, Duration> getTimeDefinitions() {
        return this.timeDefinitions;
    }
}

