/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.core.scheduler;

import com.xeiam.sundial.Job;
import com.xeiam.sundial.JobContext;
import com.xeiam.sundial.exceptions.JobInterruptException;
import java.time.LocalDateTime;
import org.craftsmenlabs.gareth.api.context.ExperimentPartState;
import org.craftsmenlabs.gareth.api.context.ExperimentRunContext;
import org.craftsmenlabs.gareth.api.invoker.MethodDescriptor;
import org.craftsmenlabs.gareth.api.invoker.MethodInvoker;
import org.craftsmenlabs.gareth.api.storage.Storage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInvocationJob
extends Job {
    private static final Logger logger = LoggerFactory.getLogger(DefaultInvocationJob.class);
    private JobContext jobContext;

    @Override
    public void doRun() throws JobInterruptException {
        block3: {
            MethodInvoker methodInvoker = (MethodInvoker)this.getJobContext().getRequiredValue("methodInvoker");
            ExperimentRunContext experimentContext = (ExperimentRunContext)this.getJobContext().getRequiredValue("experimentRunContext");
            try {
                logger.debug("Invoking assumption");
                experimentContext.setAssumeState(ExperimentPartState.RUNNING);
                this.invoke(methodInvoker, experimentContext.getExperimentContext().hasStorage(), experimentContext.getExperimentContext().getAssume(), experimentContext.getStorage());
                experimentContext.setAssumeRun(LocalDateTime.now());
                experimentContext.setAssumeState(ExperimentPartState.FINISHED);
                if (null != experimentContext.getExperimentContext().getSuccess()) {
                    logger.debug("Invoking success");
                    experimentContext.setSuccessState(ExperimentPartState.RUNNING);
                    this.invoke(methodInvoker, experimentContext.getExperimentContext().hasStorage(), experimentContext.getExperimentContext().getSuccess(), experimentContext.getStorage());
                    experimentContext.setSuccessRun(LocalDateTime.now());
                    experimentContext.setSuccessState(ExperimentPartState.FINISHED);
                }
            }
            catch (Exception e) {
                experimentContext.setAssumeState(ExperimentPartState.ERROR);
                if (null == experimentContext.getExperimentContext().getFailure()) break block3;
                logger.debug("Invoking failure");
                experimentContext.setFailureState(ExperimentPartState.RUNNING);
                this.invoke(methodInvoker, experimentContext.getExperimentContext().hasStorage(), experimentContext.getExperimentContext().getFailure(), experimentContext.getStorage());
                experimentContext.setFailureRun(LocalDateTime.now());
                experimentContext.setFailureState(ExperimentPartState.FINISHED);
            }
        }
    }

    private void invoke(MethodInvoker methodInvoker, boolean storageRequired, MethodDescriptor methodDescriptor, Storage storage) {
        if (storageRequired) {
            methodInvoker.invoke(methodDescriptor, storage);
        } else {
            methodInvoker.invoke(methodDescriptor);
        }
    }

    @Override
    protected JobContext getJobContext() {
        JobContext returnJobContext = null != this.jobContext ? this.jobContext : super.getJobContext();
        return returnJobContext;
    }

    protected void setJobContext(JobContext jobContext) {
        this.jobContext = jobContext;
    }
}

