/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.jobs;

import org.quartz.core.Scheduler;
import org.quartz.core.TriggerFiredBundle;
import org.quartz.exceptions.SchedulerException;
import org.quartz.jobs.Job;
import org.quartz.jobs.JobDetail;
import org.quartz.jobs.JobFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleJobFactory
implements JobFactory {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public Job newJob(TriggerFiredBundle bundle, Scheduler Scheduler2) throws SchedulerException {
        JobDetail jobDetail = bundle.getJobDetail();
        Class<? extends Job> jobClass = jobDetail.getJobClass();
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Producing instance of Job '" + jobDetail.getName() + "', class=" + jobClass.getName());
            }
            return jobClass.newInstance();
        }
        catch (Exception e) {
            SchedulerException se = new SchedulerException("Problem instantiating class '" + jobDetail.getJobClass().getName() + "'", e);
            throw se;
        }
    }
}

