/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.core.persist;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.craftsmenlabs.gareth.api.ExperimentEngine;
import org.craftsmenlabs.gareth.api.context.ExperimentContext;
import org.craftsmenlabs.gareth.api.context.ExperimentRunContext;
import org.craftsmenlabs.gareth.api.exception.GarethStateReadException;
import org.craftsmenlabs.gareth.api.exception.GarethStateWriteException;
import org.craftsmenlabs.gareth.api.exception.GarethUnknownExperimentException;
import org.craftsmenlabs.gareth.api.listener.ExperimentStateChangeListener;
import org.craftsmenlabs.gareth.api.persist.ExperimentEnginePersistence;
import org.craftsmenlabs.gareth.core.context.ExperimentRunContextImpl;
import org.craftsmenlabs.gareth.core.persist.ExperimentContextData;
import org.craftsmenlabs.gareth.core.persist.UnknownExperimentContextException;
import org.craftsmenlabs.gareth.core.persist.listener.FileSystemExperimentChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemExperimentEnginePersistence
implements ExperimentEnginePersistence {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemExperimentEnginePersistence.class);
    private final File stateFile;
    private final FileSystemExperimentChangeListener fileSystemExperimentChangeListener;

    private FileSystemExperimentEnginePersistence(Builder builder) {
        this.stateFile = builder.stateFile;
        this.fileSystemExperimentChangeListener = new FileSystemExperimentChangeListener.Builder(this).build();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void persist(ExperimentEngine experimentEngine) throws GarethStateWriteException {
        ArrayList data = new ArrayList();
        experimentEngine.getExperimentRunContexts().forEach(experimentRunContext -> data.add(this.buildExperimentContextData((ExperimentRunContext)experimentRunContext)));
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(this.stateFile);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(data);
        }
        catch (FileNotFoundException e) {
            try {
                LOG.error("File cannot be found", e);
                throw new GarethStateWriteException(e);
                catch (IOException e2) {
                    LOG.error("Error while writing experiment engine data", e2);
                    throw new GarethStateWriteException(e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(oos);
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(oos);
        IOUtils.closeQuietly(fos);
    }

    @Override
    public void restore(ExperimentEngine experimentEngine) throws GarethStateReadException {
        List<ExperimentContextData> experimentContextDataList = this.readExperimentContextDataFromFile();
        experimentContextDataList.forEach(experimentContextData -> {
            try {
                ExperimentContext experimentContext = experimentEngine.findExperimentContextForHash(experimentContextData.getHash());
                experimentEngine.getExperimentRunContexts().add(this.rebuildExperimentRunContext((ExperimentContextData)experimentContextData, experimentContext));
            }
            catch (GarethUnknownExperimentException e) {
                LOG.debug("No experiment context data found.", e);
            }
        });
    }

    @Override
    public ExperimentStateChangeListener getExperimentStateChangeListener() {
        return this.fileSystemExperimentChangeListener;
    }

    private ExperimentRunContext rebuildExperimentRunContext(ExperimentContextData experimentContextData, ExperimentContext experimentContext) {
        ExperimentRunContext experimentRunContext = new ExperimentRunContextImpl.Builder(experimentContext, experimentContextData.getStorage()).build();
        experimentRunContext.setBaselineState(experimentContextData.getBaselineState());
        experimentRunContext.setAssumeState(experimentContextData.getAssumeState());
        experimentRunContext.setSuccessState(experimentContextData.getSuccessState());
        experimentRunContext.setFailureState(experimentContextData.getFailureState());
        experimentRunContext.setBaselineRun(experimentContextData.getBaselineRun());
        experimentRunContext.setAssumeRun(experimentContextData.getAssumeRun());
        experimentRunContext.setSuccessRun(experimentContextData.getSuccessRun());
        experimentRunContext.setFailureRun(experimentContextData.getFailureRun());
        return experimentRunContext;
    }

    private ExperimentContextData findExperimentContextDataForHash(List<ExperimentContextData> experimentContexts, String hash) {
        return experimentContexts.parallelStream().filter(experimentContextData -> experimentContextData.getHash().equals(hash)).findFirst().orElseThrow(() -> new UnknownExperimentContextException(String.format("Cannot find experiment context data with hash %s", hash)));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<ExperimentContextData> readExperimentContextDataFromFile() throws GarethStateReadException {
        List experimentContextDataList = null;
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            fis = new FileInputStream(this.stateFile);
            ois = new ObjectInputStream(fis);
            experimentContextDataList = (List)ois.readObject();
        }
        catch (ClassNotFoundException e) {
            try {
                LOG.error("Class cannot be found", e);
                throw new GarethStateReadException(e);
                catch (FileNotFoundException e2) {
                    LOG.error("File cannot be found", e2);
                    throw new GarethStateReadException(e2);
                }
                catch (IOException e3) {
                    LOG.error("Exception while reading file", e3);
                    throw new GarethStateReadException(e3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(ois);
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(ois);
        IOUtils.closeQuietly(fis);
        return experimentContextDataList;
    }

    private ExperimentContextData buildExperimentContextData(ExperimentRunContext experimentContext) {
        ExperimentContextData experimentEngineContextData = new ExperimentContextData();
        experimentEngineContextData.setHash(experimentContext.getHash());
        experimentEngineContextData.setBaselineRun(experimentContext.getBaselineRun());
        experimentEngineContextData.setAssumeRun(experimentContext.getAssumeRun());
        experimentEngineContextData.setSuccessRun(experimentContext.getSuccessRun());
        experimentEngineContextData.setFailureRun(experimentContext.getFailureRun());
        experimentEngineContextData.setBaselineState(experimentContext.getBaselineState());
        experimentEngineContextData.setAssumeState(experimentContext.getAssumeState());
        experimentEngineContextData.setSuccessState(experimentContext.getSuccessState());
        experimentEngineContextData.setFailureState(experimentContext.getFailureState());
        experimentEngineContextData.setStorage(experimentContext.getStorage());
        return experimentEngineContextData;
    }

    public static class Builder {
        private static final String STATE_FILENAME = "gareth.state";
        private static final String TMP_DIR = System.getProperty("java.io.tmpdir");
        private File stateFile;

        public Builder setStateFile(File stateFile) {
            this.stateFile = stateFile;
            return this;
        }

        public ExperimentEnginePersistence build() {
            this.setupStateFile();
            return new FileSystemExperimentEnginePersistence(this);
        }

        private void setupStateFile() {
            if (null == this.stateFile) {
                this.stateFile = new File(TMP_DIR, STATE_FILENAME);
            }
            try {
                if (!this.stateFile.exists()) {
                    this.stateFile.createNewFile();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Cannot setup state file %s", this.stateFile.getPath()), e);
            }
        }
    }
}

