/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.core.scheduler;

import com.xeiam.sundial.SundialJobScheduler;
import java.time.Duration;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Random;
import org.craftsmenlabs.gareth.api.ExperimentEngine;
import org.craftsmenlabs.gareth.api.context.ExperimentRunContext;
import org.craftsmenlabs.gareth.api.exception.GarethInvocationException;
import org.craftsmenlabs.gareth.api.exception.GarethUnknownDefinitionException;
import org.craftsmenlabs.gareth.api.invoker.MethodInvoker;
import org.craftsmenlabs.gareth.api.observer.Observer;
import org.craftsmenlabs.gareth.api.scheduler.AssumeScheduler;
import org.craftsmenlabs.gareth.core.invoker.MethodInvokerImpl;
import org.craftsmenlabs.gareth.core.reflection.ReflectionHelper;
import org.craftsmenlabs.gareth.core.scheduler.DefaultInvocationJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAssumeScheduler
implements AssumeScheduler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAssumeScheduler.class);
    private final MethodInvoker methodInvoker;
    private final boolean ignoreInvocationExceptions;
    private final Observer observer;

    private DefaultAssumeScheduler(Builder builder) {
        this.methodInvoker = builder.methodInvoker;
        this.ignoreInvocationExceptions = builder.ignoreInvocationExceptions;
        this.observer = builder.observer;
        SundialJobScheduler.startScheduler();
    }

    @Override
    public void schedule(ExperimentRunContext experimentContext, ExperimentEngine experimentEngine) {
        block2: {
            Duration time = experimentContext.getExperimentContext().getTime();
            GregorianCalendar now = new GregorianCalendar();
            ((Calendar)now).add(14, new Long(time.toMillis()).intValue());
            try {
                HashMap<String, Object> jobParams = new HashMap<String, Object>();
                jobParams.put("experimentRunContext", experimentContext);
                jobParams.put("methodInvoker", this.methodInvoker);
                jobParams.put("observer", this.observer);
                jobParams.put("experimentEngine", experimentEngine);
                String jobName = experimentContext.getExperimentContext().getExperimentName() + "-" + new Random().nextInt();
                String triggerName = jobName + "-trigger";
                SundialJobScheduler.addJob(jobName, DefaultInvocationJob.class.getName(), jobParams, false);
                SundialJobScheduler.addSimpleTrigger(triggerName, jobName, 0, 1L, now.getTime(), null);
            }
            catch (GarethInvocationException | GarethUnknownDefinitionException e) {
                logger.error("Problem during assumption invocation", e);
                if (this.ignoreInvocationExceptions) break block2;
                throw e;
            }
        }
    }

    public static class Builder {
        private ReflectionHelper reflectionHelper = new ReflectionHelper();
        private MethodInvoker methodInvoker = new MethodInvokerImpl(this.reflectionHelper);
        private boolean ignoreInvocationExceptions;
        private final Observer observer;

        public Builder(Observer observer) {
            this.observer = observer;
        }

        public Builder setIgnoreInvocationExceptions(boolean ignoreInvocationExceptions) {
            this.ignoreInvocationExceptions = ignoreInvocationExceptions;
            return this;
        }

        public Builder setMethodInvoker(MethodInvoker methodInvoker) {
            this.methodInvoker = methodInvoker;
            return this;
        }

        public AssumeScheduler build() {
            if (null == this.observer) {
                throw new IllegalStateException("Observer cannot be null");
            }
            return new DefaultAssumeScheduler(this);
        }
    }
}

