/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.core.factory;

import java.io.InputStream;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.apache.commons.io.IOUtils;
import org.craftsmenlabs.gareth.GarethLexer;
import org.craftsmenlabs.gareth.GarethParser;
import org.craftsmenlabs.gareth.api.exception.GarethExperimentParseException;
import org.craftsmenlabs.gareth.api.factory.ExperimentFactory;
import org.craftsmenlabs.gareth.api.model.Experiment;
import org.craftsmenlabs.gareth.core.listener.ExperimentBaseListener;

public class ExperimentFactoryImpl
implements ExperimentFactory {
    @Override
    public Experiment buildExperiment(InputStream inputStream) throws GarethExperimentParseException {
        try {
            ANTLRInputStream antlrInputStream = new ANTLRInputStream(inputStream);
            GarethLexer garethLexer = new GarethLexer(antlrInputStream);
            GarethParser garethParser = new GarethParser(new CommonTokenStream(garethLexer));
            garethParser.addErrorListener(new BaseErrorListener(){

                @Override
                public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                    throw new IllegalStateException("failed to parse at line " + line + " due to " + msg, e);
                }
            });
            ExperimentBaseListener experimentListener = new ExperimentBaseListener();
            garethParser.addParseListener(experimentListener);
            garethParser.experimentBlock();
            Experiment experiment = experimentListener.getExperiment();
            return experiment;
        }
        catch (Exception e) {
            throw new GarethExperimentParseException();
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }
}

