/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.core.parser;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.craftsmenlabs.gareth.api.annotation.Assume;
import org.craftsmenlabs.gareth.api.annotation.Baseline;
import org.craftsmenlabs.gareth.api.annotation.Failure;
import org.craftsmenlabs.gareth.api.annotation.Success;
import org.craftsmenlabs.gareth.api.annotation.Time;
import org.craftsmenlabs.gareth.api.definition.ParsedDefinition;
import org.craftsmenlabs.gareth.api.definition.ParsedDefinitionFactory;
import org.craftsmenlabs.gareth.api.exception.GarethDefinitionParseException;
import org.craftsmenlabs.gareth.api.exception.GarethExperimentParseException;
import org.craftsmenlabs.gareth.api.invoker.MethodDescriptor;
import org.craftsmenlabs.gareth.api.storage.Storage;
import org.craftsmenlabs.gareth.core.invoker.MethodDescriptorImpl;
import org.craftsmenlabs.gareth.core.parser.ParsedDefinitionImpl;
import org.craftsmenlabs.gareth.core.reflection.ReflectionHelper;

public class ParsedDefinitionFactoryImpl
implements ParsedDefinitionFactory {
    private final ReflectionHelper reflectionHelper;

    public ParsedDefinitionFactoryImpl(ReflectionHelper reflectionHelper) {
        this.reflectionHelper = reflectionHelper;
    }

    @Override
    public ParsedDefinition parse(Class clazz) throws GarethExperimentParseException {
        Optional.ofNullable(clazz).orElseThrow(() -> new IllegalArgumentException("Class cannot be null"));
        ParsedDefinitionImpl parsedDefinition = new ParsedDefinitionImpl();
        this.parseClass(clazz, parsedDefinition);
        return parsedDefinition;
    }

    private void parseClass(Class clazz, ParsedDefinition parsedDefinition) {
        Stream.of(clazz.getMethods()).forEach(m -> this.parseMethod((Method)m, parsedDefinition));
    }

    private void parseMethod(Method method, ParsedDefinition parsedDefinition) {
        Optional.ofNullable(method.getAnnotation(Baseline.class)).ifPresent(baseline -> this.registerUnitOfWork(method, baseline.glueLine(), parsedDefinition.getBaselineDefinitions()));
        Optional.ofNullable(method.getAnnotation(Assume.class)).ifPresent(assume -> this.registerUnitOfWork(method, assume.glueLine(), parsedDefinition.getAssumeDefinitions()));
        Optional.ofNullable(method.getAnnotation(Success.class)).ifPresent(success -> this.registerUnitOfWork(method, success.glueLine(), parsedDefinition.getSuccessDefinitions()));
        Optional.ofNullable(method.getAnnotation(Failure.class)).ifPresent(failure -> this.registerUnitOfWork(method, failure.glueLine(), parsedDefinition.getFailureDefinitions()));
        Optional.ofNullable(method.getAnnotation(Time.class)).ifPresent(time -> this.registerDuration(method, time.glueLine(), parsedDefinition.getTimeDefinitions()));
    }

    private void registerUnitOfWork(Method method, String glueLine, Map<String, MethodDescriptor> unitOfWorkMap) {
        if (!this.isValidMethod(method)) {
            throw new IllegalStateException(String.format("Method %s with glue line '%s' is not a valid method (no void return type)", method.getName(), glueLine));
        }
        unitOfWorkMap.put(glueLine, new MethodDescriptorImpl(method, 0, this.hasStorageParameter(method)));
    }

    private void registerDuration(Method method, String glueLine, Map<String, Duration> durationMap) throws GarethDefinitionParseException {
        if (this.isValidateTimeMethod(method)) {
            try {
                Object tmpDefinition = this.reflectionHelper.getInstanceForClass(method.getDeclaringClass());
                durationMap.put(glueLine, (Duration)method.invoke(tmpDefinition, new Object[0]));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new GarethDefinitionParseException(e);
            }
        } else {
            throw new IllegalStateException(String.format("Method %s with glue line '%s' is not a valid method (no duration return type)", method.getName(), glueLine));
        }
    }

    private boolean isValidMethod(Method method) {
        return (method.getReturnType().equals(Void.class) || method.getReturnType().equals(Void.TYPE)) && this.hasValidParameters(method);
    }

    private boolean hasValidParameters(Method method) {
        return method.getParameterCount() == 0 || this.hasStorageParameter(method);
    }

    private boolean hasStorageParameter(Method method) {
        return method.getParameterCount() == 1 && method.getParameters()[0].getParameterizedType() == Storage.class;
    }

    private boolean isValidateTimeMethod(Method method) {
        return method.getReturnType().isAssignableFrom(Duration.class);
    }
}

