/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.core.observer;

import java.util.ArrayList;
import java.util.List;
import org.craftsmenlabs.gareth.api.ExperimentEngine;
import org.craftsmenlabs.gareth.api.exception.GarethStateWriteException;
import org.craftsmenlabs.gareth.api.listener.ExperimentStateChangeListener;
import org.craftsmenlabs.gareth.api.observer.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultObserver
implements Observer {
    private static final Logger logger = LoggerFactory.getLogger(DefaultObserver.class);
    private final List<ExperimentStateChangeListener> experimentStateChangeListenerList = new ArrayList<ExperimentStateChangeListener>();

    @Override
    public void notifyApplicationStateChanged(ExperimentEngine experimentEngine) {
        logger.debug("Notifying the application state listeners on change");
        for (ExperimentStateChangeListener experimentStateChangeListener : this.experimentStateChangeListenerList) {
            try {
                experimentStateChangeListener.onChange(experimentEngine);
            }
            catch (GarethStateWriteException e) {
                logger.error("Error while persisting experiment engine state");
            }
        }
    }

    @Override
    public void registerExperimentStateChangeListener(ExperimentStateChangeListener experimentStateChangeListener) {
        this.experimentStateChangeListenerList.add(experimentStateChangeListener);
    }
}

