/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.sundial;

import com.xeiam.sundial.Job;
import com.xeiam.sundial.exceptions.SchedulerStartupException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import org.quartz.builders.CronTriggerBuilder;
import org.quartz.builders.JobBuilder;
import org.quartz.builders.SimpleTriggerBuilder;
import org.quartz.core.JobExecutionContext;
import org.quartz.core.Scheduler;
import org.quartz.core.SchedulerFactory;
import org.quartz.exceptions.SchedulerException;
import org.quartz.jobs.JobDataMap;
import org.quartz.jobs.JobDetail;
import org.quartz.triggers.OperableTrigger;
import org.quartz.triggers.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SundialJobScheduler {
    static Logger logger = LoggerFactory.getLogger(SundialJobScheduler.class);
    private static Scheduler scheduler = null;
    private static boolean globalLock = false;
    private static ServletContext servletContext = null;

    public static void startScheduler() {
        SundialJobScheduler.startScheduler(10, null);
    }

    public static void startScheduler(int threadPoolSize) {
        SundialJobScheduler.startScheduler(threadPoolSize, null);
    }

    public static void startScheduler(String annotatedJobsPackageName) {
        SundialJobScheduler.startScheduler(10, annotatedJobsPackageName);
    }

    public static void startScheduler(int threadPoolSize, String annotatedJobsPackageName) {
        try {
            SundialJobScheduler.createScheduler(threadPoolSize, annotatedJobsPackageName);
            SundialJobScheduler.getScheduler().start();
        }
        catch (SchedulerException e) {
            logger.error("COULD NOT START SUNDIAL SCHEDULER!!!", e);
            throw new SchedulerStartupException(e);
        }
    }

    public static Scheduler createScheduler(int threadPoolSize, String annotatedJobsPackageName) {
        if (scheduler == null) {
            try {
                scheduler = new SchedulerFactory().getScheduler(threadPoolSize, annotatedJobsPackageName);
            }
            catch (SchedulerException e) {
                logger.error("COULD NOT CREATE SUNDIAL SCHEDULER!!!", e);
            }
        }
        return scheduler;
    }

    public static Scheduler getScheduler() {
        if (scheduler == null) {
            logger.warn("Scheduler has not yet been created!!! Call \"createScheduler\" first.");
        }
        return scheduler;
    }

    public static void toggleGlobalLock() {
        globalLock = !globalLock;
    }

    public static void lockScheduler() {
        globalLock = true;
    }

    public static void unlockScheduler() {
        globalLock = false;
    }

    public static boolean getGlobalLock() {
        return globalLock;
    }

    public static ServletContext getServletContext() {
        return servletContext;
    }

    public static void setServletContext(ServletContext servletContext) {
        SundialJobScheduler.servletContext = servletContext;
    }

    public static void addJob(String jobName, String jobClassName) {
        SundialJobScheduler.addJob(jobName, jobClassName, null, false);
    }

    public static void addJob(String jobName, String jobClassName, Map<String, Object> params, boolean isConcurrencyAllowed) {
        try {
            Class jobClass = SundialJobScheduler.getScheduler().getCascadingClassLoadHelper().loadClass(jobClassName);
            JobDataMap jobDataMap = new JobDataMap();
            if (params != null) {
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    jobDataMap.put(entry.getKey(), entry.getValue());
                }
            }
            JobDetail jobDetail = JobBuilder.newJobBuilder(jobClass).withIdentity(jobName).usingJobData(jobDataMap).isConcurrencyAllowed(isConcurrencyAllowed).build();
            SundialJobScheduler.getScheduler().addJob(jobDetail);
        }
        catch (SchedulerException e) {
            logger.error("ERROR ADDING JOB!!!", e);
        }
        catch (ClassNotFoundException e) {
            logger.error("ERROR ADDING JOB!!!", e);
        }
    }

    public static void startJob(String jobName) {
        try {
            SundialJobScheduler.getScheduler().triggerJob(jobName, null);
        }
        catch (SchedulerException e) {
            logger.error("ERROR STARTING JOB!!!", e);
        }
    }

    public static void removeJob(String jobName) {
        try {
            SundialJobScheduler.getScheduler().deleteJob(jobName);
        }
        catch (SchedulerException e) {
            logger.error("ERROR REMOVING JOB!!!", e);
        }
    }

    public static void startJob(String jobName, Map<String, Object> params) {
        try {
            JobDataMap jobDataMap = new JobDataMap();
            for (String key : params.keySet()) {
                jobDataMap.put(key, params.get(key));
            }
            SundialJobScheduler.getScheduler().triggerJob(jobName, jobDataMap);
        }
        catch (SchedulerException e) {
            logger.error("ERROR STARTING JOB!!!", e);
        }
    }

    public static void stopJob(String jobName) {
        try {
            List<JobExecutionContext> currentlyExecutingJobs = SundialJobScheduler.getScheduler().getCurrentlyExecutingJobs();
            for (JobExecutionContext jobExecutionContext : currentlyExecutingJobs) {
                String currentlyExecutingJobName = jobExecutionContext.getJobDetail().getName();
                if (currentlyExecutingJobName.equals(jobName)) {
                    logger.debug("Matching Job found. Now Stopping!");
                    if (jobExecutionContext.getJobInstance() instanceof Job) {
                        ((Job)jobExecutionContext.getJobInstance()).interrupt();
                        continue;
                    }
                    logger.warn("CANNOT STOP NON-INTERRUPTABLE JOB!!!");
                    continue;
                }
                logger.debug("Non-matching Job found. Not Stopping!");
            }
        }
        catch (SchedulerException e) {
            logger.error("ERROR STOPPING JOB!!!", e);
        }
    }

    public static void stopJob(String jobName, String key, String pValue) {
        logger.debug("key= " + key);
        logger.debug("value= " + pValue);
        try {
            List<JobExecutionContext> currentlyExecutingJobs = SundialJobScheduler.getScheduler().getCurrentlyExecutingJobs();
            for (JobExecutionContext jobExecutionContext : currentlyExecutingJobs) {
                String currentlyExecutingJobName = jobExecutionContext.getJobDetail().getName();
                if (currentlyExecutingJobName.equals(jobName)) {
                    if (jobExecutionContext.getJobInstance() instanceof Job) {
                        JobDataMap jobDataMap = jobExecutionContext.getMergedJobDataMap();
                        String value = jobDataMap.getString(key);
                        if (!(value != null & value.equalsIgnoreCase(pValue))) continue;
                        ((Job)jobExecutionContext.getJobInstance()).interrupt();
                        continue;
                    }
                    logger.warn("CANNOT STOP NON-INTERRUPTABLE JOB!!!");
                    continue;
                }
                logger.debug("Non-matching Job found. Not Stopping!");
            }
        }
        catch (SchedulerException e) {
            logger.error("ERROR DURING STOP Job!!!", e);
        }
    }

    public static void addCronTrigger(String triggerName, String jobName, String cronExpression) {
        SundialJobScheduler.addCronTrigger(triggerName, jobName, cronExpression, null, null);
    }

    public static void addCronTrigger(String triggerName, String jobName, String cronExpression, Date startTime, Date endTime) {
        try {
            CronTriggerBuilder cronTriggerBuilder = CronTriggerBuilder.cronTriggerBuilder(cronExpression);
            cronTriggerBuilder.withIdentity(triggerName).forJob(jobName).withPriority(5);
            if (startTime != null) {
                cronTriggerBuilder.startAt(startTime);
            }
            if (endTime != null) {
                cronTriggerBuilder.endAt(endTime);
            }
            OperableTrigger trigger = cronTriggerBuilder.build();
            SundialJobScheduler.getScheduler().scheduleJob(trigger);
        }
        catch (SchedulerException e) {
            logger.error("ERROR ADDING CRON TRIGGER!!!", e);
        }
        catch (ParseException e) {
            logger.error("ERROR ADDING CRON TRIGGER!!!", e);
        }
    }

    public static void addSimpleTrigger(String triggerName, String jobName, int repeatCount, long repeatInterval) {
        SundialJobScheduler.addSimpleTrigger(triggerName, jobName, repeatCount, repeatInterval, null, null);
    }

    public static void addSimpleTrigger(String triggerName, String jobName, int repeatCount, long repeatInterval, Date startTime, Date endTime) {
        try {
            SimpleTriggerBuilder simpleTriggerBuilder = SimpleTriggerBuilder.simpleTriggerBuilder();
            simpleTriggerBuilder.withRepeatCount(repeatCount).withIntervalInMilliseconds(repeatInterval).withIdentity(triggerName).forJob(jobName);
            if (startTime != null) {
                simpleTriggerBuilder.startAt(startTime);
            }
            if (endTime != null) {
                simpleTriggerBuilder.endAt(endTime);
            }
            OperableTrigger trigger = simpleTriggerBuilder.build();
            SundialJobScheduler.getScheduler().scheduleJob(trigger);
        }
        catch (SchedulerException e) {
            logger.error("ERROR ADDING CRON TRIGGER!!!", e);
        }
    }

    public static void removeTrigger(String triggerName) {
        try {
            SundialJobScheduler.getScheduler().unscheduleJob(triggerName);
        }
        catch (SchedulerException e) {
            logger.error("ERROR REMOVING TRIGGER!!!", e);
        }
    }

    public static List<String> getAllJobNames() {
        ArrayList<String> allJobNames = new ArrayList<String>();
        try {
            Set<String> allJobKeys = SundialJobScheduler.getScheduler().getJobKeys();
            for (String jobKey : allJobKeys) {
                allJobNames.add(jobKey);
            }
        }
        catch (SchedulerException e) {
            logger.error("COULD NOT GET JOB NAMES!!!", e);
        }
        Collections.sort(allJobNames);
        return allJobNames;
    }

    public static Map<String, List<Trigger>> getAllJobsAndTriggers() {
        TreeMap<String, List<Trigger>> allJobsMap = new TreeMap<String, List<Trigger>>();
        try {
            Set<String> allJobKeys = SundialJobScheduler.getScheduler().getJobKeys();
            for (String jobKey : allJobKeys) {
                List<Trigger> triggers = SundialJobScheduler.getScheduler().getTriggersOfJob(jobKey);
                allJobsMap.put(jobKey, triggers);
            }
        }
        catch (SchedulerException e) {
            logger.error("COULD NOT GET JOB NAMES!!!", e);
        }
        return allJobsMap;
    }

    public static boolean isJobRunning(String jobName) {
        try {
            List<JobExecutionContext> currentlyExecutingJobs = SundialJobScheduler.getScheduler().getCurrentlyExecutingJobs();
            for (JobExecutionContext jobExecutionContext : currentlyExecutingJobs) {
                String currentlyExecutingJobName = jobExecutionContext.getJobDetail().getName();
                if (!currentlyExecutingJobName.equals(jobName)) continue;
                logger.debug("Matching running Job found!");
                return true;
            }
        }
        catch (SchedulerException e) {
            logger.error("ERROR CHECKING RUNNING JOB!!!", e);
        }
        logger.debug("Matching running NOT Job found!");
        return false;
    }

    public static void shutdown() {
        logger.debug("shutdown() called.");
        try {
            SundialJobScheduler.getScheduler().shutdown(true);
        }
        catch (Exception e) {
            logger.error("COULD NOT SHUTDOWN SCHEDULER!!!", e);
        }
    }
}

