/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.core.context;

import java.time.Duration;
import java.util.Optional;
import javax.xml.bind.annotation.XmlRootElement;
import org.craftsmenlabs.gareth.api.context.ExperimentContext;
import org.craftsmenlabs.gareth.api.invoker.MethodDescriptor;
import org.craftsmenlabs.gareth.api.model.AssumptionBlock;

@XmlRootElement
public class ExperimentContextImpl
implements ExperimentContext {
    private final String hash;
    private final String experimentName;
    private final MethodDescriptor baseline;
    private final MethodDescriptor assume;
    private final MethodDescriptor success;
    private final MethodDescriptor failure;
    private final Duration time;
    private final String baselineGlueLine;
    private final String assumeGlueLine;
    private final String successGlueLine;
    private final String failureGlueLine;
    private final String timeGlueLine;

    private ExperimentContextImpl(String hash, Builder builder) {
        this.hash = hash;
        this.experimentName = builder.experimentName;
        this.baselineGlueLine = builder.assumptionBlock.getBaseline();
        this.assumeGlueLine = builder.assumptionBlock.getAssumption();
        this.timeGlueLine = builder.assumptionBlock.getTime();
        this.successGlueLine = builder.assumptionBlock.getSuccess();
        this.failureGlueLine = builder.assumptionBlock.getFailure();
        this.assume = builder.assume;
        this.baseline = builder.baseline;
        this.success = builder.success;
        this.failure = builder.failure;
        this.time = builder.time;
    }

    @Override
    public boolean isValid() {
        return null != this.baseline && null != this.assume && null != this.time;
    }

    @Override
    public boolean hasStorage() {
        return this.getAssume().hasStorage() || this.getBaseline().hasStorage() || null != this.getFailure() && this.getFailure().hasStorage() || null != this.getSuccess() && this.getSuccess().hasStorage();
    }

    @Override
    public String getHash() {
        return this.hash;
    }

    @Override
    public String getExperimentName() {
        return this.experimentName;
    }

    @Override
    public MethodDescriptor getBaseline() {
        return this.baseline;
    }

    @Override
    public MethodDescriptor getAssume() {
        return this.assume;
    }

    @Override
    public MethodDescriptor getSuccess() {
        return this.success;
    }

    @Override
    public MethodDescriptor getFailure() {
        return this.failure;
    }

    @Override
    public Duration getTime() {
        return this.time;
    }

    @Override
    public String getBaselineGlueLine() {
        return this.baselineGlueLine;
    }

    @Override
    public String getAssumeGlueLine() {
        return this.assumeGlueLine;
    }

    @Override
    public String getSuccessGlueLine() {
        return this.successGlueLine;
    }

    @Override
    public String getFailureGlueLine() {
        return this.failureGlueLine;
    }

    @Override
    public String getTimeGlueLine() {
        return this.timeGlueLine;
    }

    public static class Builder {
        private final String experimentName;
        private final AssumptionBlock assumptionBlock;
        private MethodDescriptor baseline;
        private MethodDescriptor assume;
        private MethodDescriptor success;
        private MethodDescriptor failure;
        private Duration time;

        public Builder(String experimentName, AssumptionBlock assumptionBlock) {
            this.experimentName = experimentName;
            this.assumptionBlock = assumptionBlock;
        }

        public Builder setBaseline(Optional<MethodDescriptor> baseline) {
            if (baseline.isPresent()) {
                this.baseline = baseline.get();
            }
            return this;
        }

        public Builder setAssume(Optional<MethodDescriptor> assume) {
            if (assume.isPresent()) {
                this.assume = assume.get();
            }
            return this;
        }

        public Builder setSuccess(Optional<MethodDescriptor> success) {
            if (success.isPresent()) {
                this.success = success.get();
            }
            return this;
        }

        public Builder setFailure(Optional<MethodDescriptor> failure) {
            if (failure.isPresent()) {
                this.failure = failure.get();
            }
            return this;
        }

        public Builder setTime(Duration time) {
            this.time = time;
            return this;
        }

        public ExperimentContext build(String hash) {
            Optional.ofNullable(hash).orElseThrow(() -> new IllegalStateException("ExperimentContext cannot be build without hash"));
            return new ExperimentContextImpl(hash, this);
        }
    }
}

