/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.core.invoker;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.craftsmenlabs.gareth.api.exception.GarethDefinitionParseException;
import org.craftsmenlabs.gareth.api.exception.GarethInvocationException;
import org.craftsmenlabs.gareth.api.storage.Storage;

public class RegexAnnotatedMethodAdapter {
    Pattern pattern;
    Method method;
    List<Class<?>> parameters = new ArrayList();

    public RegexAnnotatedMethodAdapter(Method method, String pattern) {
        this.method = method;
        this.parseMethod();
        this.setPattern(pattern);
    }

    public Method getMethod() {
        return this.method;
    }

    public void invokeWith(Object receiver, List<Object> params) {
        try {
            this.method.invoke(receiver, params.toArray(new Object[0]));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new GarethInvocationException(e);
        }
    }

    private void parseMethod() {
        for (Parameter parameter : this.method.getParameters()) {
            Class<?> cls = parameter.getType();
            if (parameter.getParameterizedType() == Storage.class) continue;
            if (!this.isValidType(cls)) {
                throw new IllegalStateException("Parameter type " + cls + " is not supported");
            }
            this.parameters.add(cls);
        }
    }

    private boolean isValidType(Type type) {
        return type.getTypeName().equals("java.lang.String") || type.getTypeName().equals("int") || type.getTypeName().equals("long") || type.getTypeName().equals("double");
    }

    public List<Class<?>> getNonStorageParameters() {
        return this.parameters.stream().filter(p -> p != Storage.class).collect(Collectors.toList());
    }

    public String getPattern() {
        return this.pattern.pattern();
    }

    private void setPattern(String regex) {
        try {
            this.pattern = Pattern.compile(regex);
        }
        catch (Exception e) {
            throw new GarethDefinitionParseException(e);
        }
    }

    public List<Object> getArgumentValuesFromInputString(String input) {
        List<String> parametersFromPattern = this.getParametersFromPattern(input.trim());
        ArrayList<Object> parameters = new ArrayList<Object>();
        for (int i = 0; i < parametersFromPattern.size(); ++i) {
            Class<?> cls = this.getNonStorageParameters().get(i);
            parameters.add(this.getValueFromString(cls, parametersFromPattern.get(i)));
        }
        return parameters;
    }

    Object getValueFromString(Class<?> cls, String stringVal) {
        if (cls == String.class) {
            return stringVal;
        }
        if (cls == Integer.TYPE) {
            return Integer.valueOf(stringVal);
        }
        if (cls == Long.TYPE) {
            return Long.valueOf(stringVal);
        }
        if (cls == Double.TYPE) {
            return Double.valueOf(stringVal);
        }
        return null;
    }

    List<String> getParametersFromPattern(String s) {
        int expectedParameters;
        ArrayList<String> output = new ArrayList<String>();
        Matcher matcher = this.pattern.matcher(s);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Input string " + s + " could not be matched against pattern " + this.getPattern());
        }
        int groupCount = matcher.groupCount();
        if (groupCount != (expectedParameters = this.getNonStorageParameters().size())) {
            throw new IllegalArgumentException("Input string " + s + " must have " + expectedParameters + " parameters.");
        }
        for (int i = 1; i <= groupCount; ++i) {
            output.add(matcher.group(i));
        }
        return output;
    }
}

