/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.core.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.craftsmenlabs.gareth.core.reflection.DefinitionFactory;

public class ReflectionHelper {
    private DefinitionFactory customDefinitionFactory;

    public ReflectionHelper(DefinitionFactory customDefinitionFactory) {
        this.customDefinitionFactory = customDefinitionFactory;
    }

    public Object getInstanceForClass(Class clazz) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        int requiredConstructorArguments;
        Object definition;
        if (this.customDefinitionFactory != null && (definition = this.customDefinitionFactory.createDefinition(clazz)) != null) {
            return definition;
        }
        Constructor<?> constructor = null;
        Object declaringClassInstance = null;
        boolean memberClass = clazz.isMemberClass();
        int n = requiredConstructorArguments = memberClass ? 1 : 0;
        if (memberClass) {
            declaringClassInstance = this.getInstanceForClass(clazz.getDeclaringClass());
        }
        for (Constructor<?> declaredConstructor : clazz.getDeclaredConstructors()) {
            if (declaredConstructor.getGenericParameterTypes().length != requiredConstructorArguments) continue;
            constructor = declaredConstructor;
            break;
        }
        if (null != constructor) {
            constructor.setAccessible(true);
            Object instance = memberClass ? constructor.newInstance(declaringClassInstance) : constructor.newInstance(new Object[0]);
            return instance;
        }
        throw new InstantiationException(String.format("Class %s has no zero argument argument constructor", clazz));
    }
}

