/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.core.registry;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.craftsmenlabs.gareth.api.exception.GarethAlreadyKnownDefinitionException;
import org.craftsmenlabs.gareth.api.exception.GarethUnknownDefinitionException;
import org.craftsmenlabs.gareth.api.invoker.MethodDescriptor;
import org.craftsmenlabs.gareth.api.registry.DefinitionRegistry;
import org.craftsmenlabs.gareth.core.parser.CommonDurationExpressionParser;

public class DefinitionRegistryImpl
implements DefinitionRegistry {
    private final Map<String, Pattern> regexes = new HashMap<String, Pattern>();
    CommonDurationExpressionParser durationExpressionParser = new CommonDurationExpressionParser();
    private final Map<String, MethodDescriptor> baselineDefinitions = new HashMap<String, MethodDescriptor>();
    private final Map<String, MethodDescriptor> assumeDefinitions = new HashMap<String, MethodDescriptor>();
    private final Map<String, MethodDescriptor> successDefinitions = new HashMap<String, MethodDescriptor>();
    private final Map<String, MethodDescriptor> failureDefinitions = new HashMap<String, MethodDescriptor>();
    private final Map<String, Duration> timeDefinitions = new HashMap<String, Duration>();

    @Override
    public Map<String, Set<String>> getGlueLinesPerCategory() {
        HashMap<String, Set<String>> allPatterns = new HashMap<String, Set<String>>();
        allPatterns.put("assume", this.assumeDefinitions.keySet());
        allPatterns.put("baseline", this.baselineDefinitions.keySet());
        allPatterns.put("success", this.successDefinitions.keySet());
        allPatterns.put("failure", this.failureDefinitions.keySet());
        allPatterns.put("time", this.timeDefinitions.keySet());
        return allPatterns;
    }

    @Override
    public MethodDescriptor getMethodDescriptorForBaseline(String glueLine) {
        return this.getDefinition(this.getBaselineDefinitions(), glueLine);
    }

    @Override
    public MethodDescriptor getMethodDescriptorForAssume(String glueLine) {
        return this.getDefinition(this.getAssumeDefinitions(), glueLine);
    }

    @Override
    public MethodDescriptor getMethodDescriptorForSuccess(String glueLine) {
        return this.getDefinition(this.getSuccessDefinitions(), glueLine);
    }

    @Override
    public MethodDescriptor getMethodDescriptorForFailure(String glueLine) {
        return this.getDefinition(this.getFailureDefinitions(), glueLine);
    }

    @Override
    public void addMethodDescriptorForBaseline(String glueLine, MethodDescriptor method) {
        this.addDefinition(this.getBaselineDefinitions(), glueLine, method);
    }

    @Override
    public void addMethodDescriptorForAssume(String glueLine, MethodDescriptor method) {
        this.addDefinition(this.getAssumeDefinitions(), glueLine, method);
    }

    @Override
    public void addMethodDescriptorForSuccess(String glueLine, MethodDescriptor method) {
        this.addDefinition(this.getSuccessDefinitions(), glueLine, method);
    }

    @Override
    public void addMethodDescriptorForFailure(String glueLine, MethodDescriptor method) {
        this.addDefinition(this.getFailureDefinitions(), glueLine, method);
    }

    @Override
    public Duration getDurationForTime(String glueLine) {
        return this.getTimeDefinition(this.getTimeDefinitions(), glueLine);
    }

    @Override
    public void addDurationForTime(String glueLine, Duration duration) {
        this.addDefinition(this.getTimeDefinitions(), glueLine, duration);
    }

    private MethodDescriptor getDefinition(Map<String, MethodDescriptor> valueMap, String experimentLine) {
        Optional<MethodDescriptor> match = valueMap.values().stream().filter(md -> this.matchesPattern(experimentLine, md.getRegexPatternForGlueLine())).findFirst();
        return match.orElseThrow(() -> new GarethUnknownDefinitionException(String.format("No definition found for glue line '%s'", experimentLine)));
    }

    private <T> T getTimeDefinition(Map<String, T> valueMap, String experimentLine) {
        Optional<String> match = valueMap.keySet().stream().filter(annotationPattern -> this.matchesPattern(experimentLine, (String)annotationPattern)).findFirst();
        if (match.isPresent()) {
            return valueMap.get(match.get());
        }
        Optional<Duration> duration = this.durationExpressionParser.parse(experimentLine);
        return (T)duration.orElseThrow(() -> new GarethUnknownDefinitionException("No definition found for glue line " + experimentLine));
    }

    private <T> void addDefinition(Map<String, T> valueMap, String glueLine, T definition) {
        if (valueMap.containsKey(glueLine)) {
            throw new GarethAlreadyKnownDefinitionException(String.format("Glue line already registered for '%s'", glueLine));
        }
        valueMap.put(glueLine, definition);
    }

    private boolean matchesPattern(String experimentLine, String pattern) {
        if (experimentLine == null || pattern == null) {
            return false;
        }
        return this.getGlueLinePattern(pattern).matcher(experimentLine).matches();
    }

    private Pattern getGlueLinePattern(String pattern) {
        if (this.regexes.containsKey(pattern)) {
            return this.regexes.get(pattern);
        }
        Pattern compiled = Pattern.compile(pattern);
        this.regexes.put(pattern, compiled);
        return compiled;
    }

    public Map<String, Pattern> getRegexes() {
        return this.regexes;
    }

    public CommonDurationExpressionParser getDurationExpressionParser() {
        return this.durationExpressionParser;
    }

    public Map<String, MethodDescriptor> getBaselineDefinitions() {
        return this.baselineDefinitions;
    }

    public Map<String, MethodDescriptor> getAssumeDefinitions() {
        return this.assumeDefinitions;
    }

    public Map<String, MethodDescriptor> getSuccessDefinitions() {
        return this.successDefinitions;
    }

    public Map<String, MethodDescriptor> getFailureDefinitions() {
        return this.failureDefinitions;
    }

    public Map<String, Duration> getTimeDefinitions() {
        return this.timeDefinitions;
    }
}

