/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.core.scheduler;

import com.xeiam.sundial.Job;
import com.xeiam.sundial.JobContext;
import com.xeiam.sundial.exceptions.JobInterruptException;
import java.time.LocalDateTime;
import org.craftsmenlabs.gareth.api.ExperimentEngine;
import org.craftsmenlabs.gareth.api.context.ExperimentPartState;
import org.craftsmenlabs.gareth.api.context.ExperimentRunContext;
import org.craftsmenlabs.gareth.api.invoker.MethodDescriptor;
import org.craftsmenlabs.gareth.api.invoker.MethodInvoker;
import org.craftsmenlabs.gareth.api.observer.Observer;
import org.craftsmenlabs.gareth.api.storage.Storage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInvocationJob
extends Job {
    private static final Logger logger = LoggerFactory.getLogger(DefaultInvocationJob.class);
    private JobContext jobContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRun() throws JobInterruptException {
        MethodInvoker methodInvoker = (MethodInvoker)this.getJobContext().getRequiredValue("methodInvoker");
        ExperimentRunContext runContext = (ExperimentRunContext)this.getJobContext().getRequiredValue("experimentRunContext");
        Observer observer = (Observer)this.getJobContext().getRequiredValue("observer");
        ExperimentEngine experimentEngine = (ExperimentEngine)this.getJobContext().getRequiredValue("experimentEngine");
        try {
            logger.debug("Invoking assumption");
            runContext.setAssumeState(ExperimentPartState.RUNNING);
            String assumeGlueLine = runContext.getExperimentContext().getAssumeGlueLine();
            this.invoke(assumeGlueLine, methodInvoker, runContext.getExperimentContext().hasStorage(), runContext.getExperimentContext().getAssume(), runContext.getStorage());
            runContext.setAssumeRun(LocalDateTime.now());
            runContext.setAssumeState(ExperimentPartState.FINISHED);
            if (null != runContext.getExperimentContext().getSuccess()) {
                logger.debug("Invoking success");
                runContext.setSuccessState(ExperimentPartState.RUNNING);
                this.invoke(runContext.getExperimentContext().getSuccessGlueLine(), methodInvoker, runContext.getExperimentContext().hasStorage(), runContext.getExperimentContext().getSuccess(), runContext.getStorage());
                runContext.setSuccessRun(LocalDateTime.now());
                runContext.setSuccessState(ExperimentPartState.FINISHED);
            }
        }
        catch (Exception e) {
            runContext.setAssumeState(ExperimentPartState.ERROR);
            if (null != runContext.getExperimentContext().getFailure()) {
                logger.debug("Invoking failure");
                runContext.setFailureState(ExperimentPartState.RUNNING);
                this.invoke(runContext.getExperimentContext().getFailureGlueLine(), methodInvoker, runContext.getExperimentContext().hasStorage(), runContext.getExperimentContext().getFailure(), runContext.getStorage());
                runContext.setFailureRun(LocalDateTime.now());
                runContext.setFailureState(ExperimentPartState.FINISHED);
            }
        }
        finally {
            observer.notifyApplicationStateChanged(experimentEngine);
        }
    }

    private void invoke(String assumeGlueLine, MethodInvoker methodInvoker, boolean storageRequired, MethodDescriptor methodDescriptor, Storage storage) {
        if (storageRequired) {
            methodInvoker.invoke(assumeGlueLine, methodDescriptor, storage);
        } else {
            methodInvoker.invoke(assumeGlueLine, methodDescriptor);
        }
    }

    @Override
    protected JobContext getJobContext() {
        JobContext returnJobContext = null != this.jobContext ? this.jobContext : super.getJobContext();
        return returnJobContext;
    }

    protected void setJobContext(JobContext jobContext) {
        this.jobContext = jobContext;
    }
}

