/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.core.storage;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.craftsmenlabs.gareth.api.storage.Storage;

public class DefaultStorage
implements Storage {
    private final Map<String, Serializable> keyValueMap = new HashMap<String, Serializable>();

    @Override
    public Optional<? extends Serializable> get(String name) {
        return Optional.ofNullable(this.keyValueMap.get(name));
    }

    @Override
    public void store(String name, Serializable object) {
        this.keyValueMap.put(name, object);
    }

    @Override
    public <T extends Serializable> Optional<T> get(String name, Class<T> clazz) {
        Optional<? extends Serializable> bla = this.get(name);
        Optional optional = Optional.empty();
        if (bla.isPresent() && bla.get().getClass().equals(clazz)) {
            optional = Optional.of(clazz.cast(bla.get()));
        }
        return optional;
    }

    @Override
    public Set<String> getStorageKeys() {
        return this.keyValueMap.keySet();
    }
}

