/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.core.util;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentContextHashGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(ExperimentContextHashGenerator.class);

    public static String generateHash(String[] unhashedSurrogateKey) {
        byte[] digest = new byte[]{};
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.reset();
            String unhashedKey = ExperimentContextHashGenerator.buildUnhashedKey(unhashedSurrogateKey);
            md.update(unhashedKey.getBytes("UTF-8"));
            digest = md.digest();
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            LOG.error("Cannot generate hash for experiment context");
        }
        return String.format("%064x", new BigInteger(1, digest));
    }

    private static String buildUnhashedKey(String[] unhashedSurrogateKey) {
        StringBuilder stringBuilder = new StringBuilder("");
        Optional.ofNullable(unhashedSurrogateKey).ifPresent(key -> Arrays.stream(unhashedSurrogateKey).map(e -> Optional.ofNullable(e).orElse("-")).forEach(e -> stringBuilder.append((String)e)));
        return stringBuilder.toString();
    }
}

