/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.examples.definition;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.craftsmenlabs.gareth.api.annotation.Assume;
import org.craftsmenlabs.gareth.api.annotation.Baseline;
import org.craftsmenlabs.gareth.api.annotation.Failure;
import org.craftsmenlabs.gareth.api.annotation.Success;
import org.craftsmenlabs.gareth.api.annotation.Time;
import org.craftsmenlabs.gareth.api.storage.Storage;
import org.craftsmenlabs.gareth.core.expect.Expect;

public class SampleDefinition {
    @Baseline(glueLine="sale of (.*?)")
    public void sampleBaseline(Storage storage, String product) {
        storage.store(product, Float.valueOf(100.0f));
        System.out.println("Getting sale of " + product);
    }

    @Assume(glueLine="sale of (.*?) has gone up by (\\d{1,3})%")
    public void sampleAssume(Storage storage, String product, int percentage) {
        float ratioExpected;
        float salesThisMonth = 105.0f;
        Float salesLastMonth = storage.get(product, Float.class).get();
        float salesIncrease = salesThisMonth / salesLastMonth.floatValue();
        if (salesIncrease < (ratioExpected = 1.0f + (float)percentage / 100.0f)) {
            Expect.fail("sales percentage is " + salesIncrease);
        }
        System.out.println("Sale of " + product + " has gone up by percentage " + salesIncrease);
    }

    @Time(glueLine="1 minute")
    public Duration sampleTime() {
        return Duration.of(2L, ChronoUnit.SECONDS);
    }

    @Success(glueLine="order (\\d{1,3}) (.*?) from (.*?)")
    public void sampleSuccess(int amount, String treat, String supplier) {
        System.out.println("Stuff yourself with " + treat + " from " + supplier);
    }

    @Failure(glueLine="fire (\\d+?) (.*?) at random")
    public void sampleFailure(String nmb, String victim) {
        System.out.println("Firing " + nmb + " " + victim);
    }
}

