/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.builders;

import java.util.UUID;
import org.quartz.jobs.Job;
import org.quartz.jobs.JobDataMap;
import org.quartz.jobs.JobDetail;
import org.quartz.jobs.JobDetailImpl;
import org.quartz.jobs.NoOpJob;

public class JobBuilder {
    private String key;
    private String description;
    private Class<? extends Job> jobClass = NoOpJob.class;
    private boolean durability = true;
    private boolean isConcurrencyAllowed = false;
    private JobDataMap jobDataMap = new JobDataMap();

    private JobBuilder() {
    }

    public static JobBuilder newJobBuilder() {
        return new JobBuilder();
    }

    public static JobBuilder newJobBuilder(Class<? extends Job> jobClass) {
        JobBuilder b = new JobBuilder();
        b.ofType(jobClass);
        return b;
    }

    public JobDetail build() {
        JobDetailImpl job = new JobDetailImpl();
        job.setJobClass(this.jobClass);
        job.setDescription(this.description);
        if (this.key == null) {
            this.key = UUID.randomUUID().toString();
        }
        job.setName(this.key);
        job.setIsConcurrencyAllowed(this.isConcurrencyAllowed);
        if (!this.jobDataMap.isEmpty()) {
            job.setJobDataMap(this.jobDataMap);
        }
        return job;
    }

    public JobBuilder withIdentity(String key) {
        this.key = key;
        return this;
    }

    public JobBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public JobBuilder ofType(Class<? extends Job> jobClass) {
        this.jobClass = jobClass;
        return this;
    }

    public JobBuilder isConcurrencyAllowed(boolean isConcurrencyAllowed) {
        this.isConcurrencyAllowed = isConcurrencyAllowed;
        return this;
    }

    public JobBuilder usingJobData(JobDataMap newJobDataMap) {
        this.jobDataMap = newJobDataMap;
        return this;
    }
}

