/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.builders;

import org.quartz.builders.TriggerBuilder;
import org.quartz.triggers.OperableTrigger;
import org.quartz.triggers.SimpleTriggerImpl;

public class SimpleTriggerBuilder
extends TriggerBuilder {
    private long interval = 0L;
    private int repeatCount = 0;
    private int misfireInstruction = 0;

    private SimpleTriggerBuilder() {
    }

    public static SimpleTriggerBuilder simpleTriggerBuilder() {
        return new SimpleTriggerBuilder();
    }

    @Override
    public OperableTrigger instantiate() {
        SimpleTriggerImpl st = new SimpleTriggerImpl();
        st.setRepeatInterval(this.interval);
        st.setRepeatCount(this.repeatCount);
        st.setMisfireInstruction(this.misfireInstruction);
        return st;
    }

    public SimpleTriggerBuilder withIntervalInMilliseconds(long intervalInMillis) {
        this.interval = intervalInMillis;
        return this;
    }

    public SimpleTriggerBuilder withRepeatCount(int repeatCount) {
        this.repeatCount = repeatCount;
        return this;
    }

    public SimpleTriggerBuilder repeatForever() {
        this.repeatCount = -1;
        return this;
    }

    public SimpleTriggerBuilder withMisfireHandlingInstructionFireNow() {
        this.misfireInstruction = 1;
        return this;
    }

    public SimpleTriggerBuilder withMisfireHandlingInstructionNextWithExistingCount() {
        this.misfireInstruction = 5;
        return this;
    }

    public SimpleTriggerBuilder withMisfireHandlingInstructionNextWithRemainingCount() {
        this.misfireInstruction = 4;
        return this;
    }

    public SimpleTriggerBuilder withMisfireHandlingInstructionNowWithExistingCount() {
        this.misfireInstruction = 2;
        return this;
    }

    public SimpleTriggerBuilder withMisfireHandlingInstructionNowWithRemainingCount() {
        this.misfireInstruction = 3;
        return this;
    }
}

