/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core;

import org.quartz.QuartzScheduler;
import org.quartz.core.JobExecutionContext;
import org.quartz.core.JobExecutionContextImpl;
import org.quartz.core.Scheduler;
import org.quartz.core.TriggerFiredBundle;
import org.quartz.exceptions.JobExecutionException;
import org.quartz.exceptions.JobPersistenceException;
import org.quartz.exceptions.SchedulerException;
import org.quartz.jobs.Job;
import org.quartz.jobs.JobDetail;
import org.quartz.listeners.SchedulerListenerSupport;
import org.quartz.triggers.OperableTrigger;
import org.quartz.triggers.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobRunShell
extends SchedulerListenerSupport
implements Runnable {
    private JobExecutionContextImpl jec = null;
    private QuartzScheduler qs = null;
    private TriggerFiredBundle firedTriggerBundle = null;
    private Scheduler scheduler = null;
    private volatile boolean shutdownRequested = false;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    JobRunShell(Scheduler scheduler, TriggerFiredBundle bndle) {
        this.scheduler = scheduler;
        this.firedTriggerBundle = bndle;
    }

    @Override
    public void schedulerShuttingdown() {
        this.requestShutdown();
    }

    @Override
    protected Logger getLog() {
        return this.log;
    }

    void initialize(QuartzScheduler qs) throws SchedulerException {
        this.qs = qs;
        Job job = null;
        JobDetail jobDetail = this.firedTriggerBundle.getJobDetail();
        try {
            job = qs.getJobFactory().newJob(this.firedTriggerBundle, this.scheduler);
        }
        catch (SchedulerException se) {
            qs.notifySchedulerListenersError("An error occured instantiating job to be executed. job= '" + jobDetail.getName() + "'", se);
            throw se;
        }
        catch (Throwable ncdfe) {
            SchedulerException se = new SchedulerException("Problem instantiating class '" + jobDetail.getJobClass().getName() + "' - ", ncdfe);
            qs.notifySchedulerListenersError("An error occured instantiating job to be executed. job= '" + jobDetail.getName() + "'", se);
            throw se;
        }
        this.jec = new JobExecutionContextImpl(this.scheduler, this.firedTriggerBundle, job);
    }

    private void requestShutdown() {
        this.shutdownRequested = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block29: {
            this.qs.addInternalSchedulerListener(this);
            try {
                Trigger.CompletedExecutionInstruction instCode;
                OperableTrigger trigger = (OperableTrigger)this.jec.getTrigger();
                JobDetail jobDetail = this.jec.getJobDetail();
                while (true) {
                    long startTime;
                    Job job;
                    JobExecutionException jobExEx;
                    block30: {
                        jobExEx = null;
                        job = this.jec.getJobInstance();
                        try {
                            this.begin();
                        }
                        catch (SchedulerException se) {
                            this.qs.notifySchedulerListenersError("Error executing Job (" + this.jec.getJobDetail().getName() + ": couldn't begin execution.", se);
                            break block29;
                        }
                        try {
                            if (!this.notifyListenersBeginning(this.jec)) {
                            }
                            break block30;
                        }
                        catch (VetoedException ve) {
                            try {
                                Trigger.CompletedExecutionInstruction instCode2 = trigger.executionComplete(this.jec, null);
                                try {
                                    this.qs.notifyJobStoreJobVetoed(trigger, jobDetail, instCode2);
                                }
                                catch (JobPersistenceException jpe) {
                                    this.vetoedJobRetryLoop(trigger, jobDetail, instCode2);
                                }
                                this.complete(true);
                                break block29;
                            }
                            catch (SchedulerException se) {
                                this.qs.notifySchedulerListenersError("Error during veto of Job (" + this.jec.getJobDetail().getName() + ": couldn't finalize execution.", se);
                            }
                        }
                        break block29;
                    }
                    long endTime = startTime = System.currentTimeMillis();
                    try {
                        this.log.debug("Calling execute on job " + jobDetail.getName());
                        job.execute(this.jec);
                        endTime = System.currentTimeMillis();
                    }
                    catch (JobExecutionException jee) {
                        endTime = System.currentTimeMillis();
                        jobExEx = jee;
                        this.getLog().info("Job " + jobDetail.getName() + " threw a JobExecutionException: ", jobExEx);
                    }
                    catch (Throwable e) {
                        endTime = System.currentTimeMillis();
                        this.getLog().error("Job " + jobDetail.getName() + " threw an unhandled Exception: ", e);
                        SchedulerException se = new SchedulerException("Job threw an unhandled exception.", e);
                        this.qs.notifySchedulerListenersError("Job (" + this.jec.getJobDetail().getName() + " threw an exception.", se);
                        jobExEx = new JobExecutionException(se, false);
                    }
                    this.jec.setJobRunTime(endTime - startTime);
                    if (!this.notifyJobListenersComplete(this.jec, jobExEx)) {
                        break block29;
                    }
                    instCode = Trigger.CompletedExecutionInstruction.NOOP;
                    try {
                        instCode = trigger.executionComplete(this.jec, jobExEx);
                    }
                    catch (Exception e) {
                        SchedulerException se = new SchedulerException("Trigger threw an unhandled exception.", e);
                        this.qs.notifySchedulerListenersError("Please report this error to the Quartz developers.", se);
                    }
                    if (!this.notifyTriggerListenersComplete(this.jec, instCode)) {
                        break block29;
                    }
                    if (instCode == Trigger.CompletedExecutionInstruction.RE_EXECUTE_JOB) {
                        this.jec.incrementRefireCount();
                        try {
                            this.complete(false);
                        }
                        catch (SchedulerException se) {
                            this.qs.notifySchedulerListenersError("Error executing Job (" + this.jec.getJobDetail().getName() + ": couldn't finalize execution.", se);
                        }
                        continue;
                    }
                    try {
                        this.complete(true);
                    }
                    catch (SchedulerException se) {
                        this.qs.notifySchedulerListenersError("Error executing Job (" + this.jec.getJobDetail().getName() + ": couldn't finalize execution.", se);
                        continue;
                    }
                    break;
                }
                try {
                    this.qs.notifyJobStoreJobComplete(trigger, jobDetail, instCode);
                }
                catch (JobPersistenceException jpe) {
                    this.qs.notifySchedulerListenersError("An error occured while marking executed job complete. job= '" + jobDetail.getName() + "'", jpe);
                    if (!this.completeTriggerRetryLoop(trigger, jobDetail, instCode)) {
                        this.qs.removeInternalSchedulerListener(this);
                        return;
                    }
                }
            }
            finally {
                this.qs.removeInternalSchedulerListener(this);
            }
        }
    }

    private void begin() throws SchedulerException {
    }

    private void complete(boolean successfulExecution) throws SchedulerException {
    }

    private boolean notifyListenersBeginning(JobExecutionContext jec) throws VetoedException {
        boolean vetoed = false;
        try {
            vetoed = this.qs.notifyTriggerListenersFired(jec);
        }
        catch (SchedulerException se) {
            this.qs.notifySchedulerListenersError("Unable to notify TriggerListener(s) while firing trigger (Trigger and Job will NOT be fired!). trigger= " + jec.getTrigger().getName() + " job= " + jec.getJobDetail().getName(), se);
            return false;
        }
        if (vetoed) {
            try {
                this.qs.notifyJobListenersWasVetoed(jec);
            }
            catch (SchedulerException se) {
                this.qs.notifySchedulerListenersError("Unable to notify JobListener(s) of vetoed execution while firing trigger (Trigger and Job will NOT be fired!). trigger= " + jec.getTrigger().getName() + " job= " + jec.getJobDetail().getName(), se);
            }
            throw new VetoedException();
        }
        try {
            this.qs.notifyJobListenersToBeExecuted(jec);
        }
        catch (SchedulerException se) {
            this.qs.notifySchedulerListenersError("Unable to notify JobListener(s) of Job to be executed: (Job will NOT be executed!). trigger= " + jec.getTrigger().getName() + " job= " + jec.getJobDetail().getName(), se);
            return false;
        }
        return true;
    }

    private boolean notifyJobListenersComplete(JobExecutionContext jec, JobExecutionException jobExEx) {
        try {
            this.qs.notifyJobListenersWasExecuted(jec, jobExEx);
        }
        catch (SchedulerException se) {
            this.qs.notifySchedulerListenersError("Unable to notify JobListener(s) of Job that was executed: (error will be ignored). trigger= " + jec.getTrigger().getName() + " job= " + jec.getJobDetail().getName(), se);
            return false;
        }
        return true;
    }

    private boolean notifyTriggerListenersComplete(JobExecutionContext jec, Trigger.CompletedExecutionInstruction instCode) {
        try {
            this.qs.notifyTriggerListenersComplete(jec, instCode);
        }
        catch (SchedulerException se) {
            this.qs.notifySchedulerListenersError("Unable to notify TriggerListener(s) of Job that was executed: (error will be ignored). trigger= " + jec.getTrigger().getName() + " job= " + jec.getJobDetail().getName(), se);
            return false;
        }
        if (jec.getTrigger().getNextFireTime() == null) {
            this.qs.notifySchedulerListenersFinalized(jec.getTrigger());
        }
        return true;
    }

    private boolean completeTriggerRetryLoop(OperableTrigger trigger, JobDetail jobDetail, Trigger.CompletedExecutionInstruction instCode) {
        long count = 0L;
        while (!this.shutdownRequested && !this.qs.isShuttingDown()) {
            try {
                Thread.sleep(15000L);
                this.qs.notifyJobStoreJobComplete(trigger, jobDetail, instCode);
                return true;
            }
            catch (JobPersistenceException jpe) {
                if (count % 4L == 0L) {
                    this.qs.notifySchedulerListenersError("An error occured while marking executed job complete (will continue attempts). job= '" + jobDetail.getName() + "'", jpe);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++count;
        }
        return false;
    }

    private boolean vetoedJobRetryLoop(OperableTrigger trigger, JobDetail jobDetail, Trigger.CompletedExecutionInstruction instCode) {
        while (!this.shutdownRequested) {
            try {
                Thread.sleep(5000L);
                this.qs.notifyJobStoreJobVetoed(trigger, jobDetail, instCode);
                return true;
            }
            catch (JobPersistenceException jpe) {
                this.qs.notifySchedulerListenersError("An error occured while marking executed job vetoed. job= '" + jobDetail.getName() + "'", jpe);
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return false;
    }

    private static class VetoedException
    extends Exception {
    }
}

