/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.core;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.craftsmenlabs.gareth.api.ExperimentEngineConfig;
import org.craftsmenlabs.gareth.api.context.ExperimentContext;
import org.craftsmenlabs.gareth.api.exception.GarethInvocationException;
import org.craftsmenlabs.gareth.api.exception.GarethUnknownDefinitionException;
import org.craftsmenlabs.gareth.api.invoker.MethodDescriptor;
import org.craftsmenlabs.gareth.api.model.AssumptionBlock;
import org.craftsmenlabs.gareth.api.model.Experiment;
import org.craftsmenlabs.gareth.api.registry.DefinitionRegistry;
import org.craftsmenlabs.gareth.core.context.ExperimentContextImpl;
import org.craftsmenlabs.gareth.core.util.ExperimentContextHashGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentContextBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ExperimentContextBuilder.class);
    DefinitionRegistry definitionRegistry;
    ExperimentEngineConfig experimentEngineConfig;

    public ExperimentContextBuilder(DefinitionRegistry definitionRegistry, ExperimentEngineConfig experimentEngineConfig) {
        this.definitionRegistry = definitionRegistry;
        this.experimentEngineConfig = experimentEngineConfig;
    }

    ExperimentContext build(Experiment experiment) {
        return this.build(Arrays.asList(experiment)).get(0);
    }

    List<ExperimentContext> build(List<Experiment> experiments) {
        ArrayList<ExperimentContext> experimentContexts = new ArrayList<ExperimentContext>();
        logger.info("Populating experiment contexts");
        for (Experiment experiment : experiments) {
            for (AssumptionBlock assumptionBlock : experiment.getAssumptionBlockList()) {
                String[] surrogateKey = new String[]{experiment.getExperimentName(), assumptionBlock.getBaseline(), assumptionBlock.getAssumption(), assumptionBlock.getTime(), assumptionBlock.getSuccess(), assumptionBlock.getFailure()};
                String hashedSurrogateKey = ExperimentContextHashGenerator.generateHash(surrogateKey);
                ExperimentContext experimentContext = new ExperimentContextImpl.Builder(experiment.getExperimentName(), assumptionBlock).setBaseline(Optional.ofNullable(this.getBaseline(assumptionBlock.getBaseline()))).setAssume(Optional.ofNullable(this.getAssume(assumptionBlock.getAssumption()))).setTime(this.getDuration(assumptionBlock.getTime())).setFailure(Optional.ofNullable(this.getFailure(assumptionBlock.getFailure()))).setSuccess(Optional.ofNullable(this.getSuccess(assumptionBlock.getSuccess()))).build(hashedSurrogateKey);
                experimentContexts.add(experimentContext);
            }
        }
        logger.info(String.format("Added %d different experiments", experimentContexts.size()));
        return experimentContexts;
    }

    private Duration getDuration(String timeGlueLine) {
        Duration duration = null;
        try {
            duration = this.definitionRegistry.getDurationForTime(timeGlueLine);
        }
        catch (GarethUnknownDefinitionException e) {
            throw new GarethInvocationException(e);
        }
        return duration;
    }

    private MethodDescriptor getSuccess(String glueLine) {
        MethodDescriptor method;
        block2: {
            method = null;
            try {
                method = this.definitionRegistry.getMethodDescriptorForSuccess(glueLine);
            }
            catch (GarethUnknownDefinitionException e) {
                if (!this.experimentEngineConfig.isIgnoreInvalidDefinitions()) break block2;
                throw e;
            }
        }
        return method;
    }

    private MethodDescriptor getAssume(String glueLine) {
        MethodDescriptor method;
        block2: {
            method = null;
            try {
                method = this.definitionRegistry.getMethodDescriptorForAssume(glueLine);
            }
            catch (GarethUnknownDefinitionException e) {
                if (!this.experimentEngineConfig.isIgnoreInvalidDefinitions()) break block2;
                throw e;
            }
        }
        return method;
    }

    private MethodDescriptor getBaseline(String glueLine) {
        MethodDescriptor method;
        block2: {
            method = null;
            try {
                method = this.definitionRegistry.getMethodDescriptorForBaseline(glueLine);
            }
            catch (GarethUnknownDefinitionException e) {
                if (!this.experimentEngineConfig.isIgnoreInvalidDefinitions()) break block2;
                throw e;
            }
        }
        return method;
    }

    private MethodDescriptor getFailure(String glueLine) {
        MethodDescriptor method;
        block2: {
            method = null;
            try {
                method = this.definitionRegistry.getMethodDescriptorForFailure(glueLine);
            }
            catch (GarethUnknownDefinitionException e) {
                if (!this.experimentEngineConfig.isIgnoreInvalidDefinitions()) break block2;
                throw e;
            }
        }
        return method;
    }
}

