/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.core;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.craftsmenlabs.gareth.api.ExperimentEngineConfig;

public class ExperimentEngineConfigImpl
implements ExperimentEngineConfig {
    private final Set<Class> definitionClasses;
    private final List<InputStream> inputStreamList;
    private final boolean ignoreInvalidDefinitions;
    private final boolean ignoreInvalidExperiments;
    private final boolean ignoreInvocationExceptions;

    private ExperimentEngineConfigImpl(Builder builder) {
        this.definitionClasses = builder.definitionClasses;
        this.inputStreamList = builder.inputStreams;
        this.ignoreInvalidDefinitions = builder.ignoreInvalidDefinitions;
        this.ignoreInvalidExperiments = builder.ignoreInvalidExperiments;
        this.ignoreInvocationExceptions = builder.ignoreInvocationExceptions;
    }

    @Override
    public Class[] getDefinitionClasses() {
        return this.definitionClasses.toArray(new Class[this.definitionClasses.size()]);
    }

    @Override
    public InputStream[] getInputStreams() {
        return this.inputStreamList.toArray(new InputStream[this.inputStreamList.size()]);
    }

    @Override
    public boolean isIgnoreInvalidDefinitions() {
        return this.ignoreInvalidDefinitions;
    }

    @Override
    public boolean isIgnoreInvalidExperiments() {
        return this.ignoreInvalidExperiments;
    }

    @Override
    public boolean isIgnoreInvocationExceptions() {
        return this.ignoreInvocationExceptions;
    }

    public static class Builder {
        private final Set<Class> definitionClasses = new HashSet<Class>();
        private final List<InputStream> inputStreams = new ArrayList<InputStream>();
        private boolean ignoreInvalidDefinitions;
        private boolean ignoreInvalidExperiments;
        private boolean ignoreInvocationExceptions;

        public Builder addInputStreams(InputStream inputStream) {
            this.inputStreams.add(inputStream);
            return this;
        }

        public Builder addInputStreams(Collection<InputStream> inputStreams) {
            this.inputStreams.addAll(inputStreams);
            return this;
        }

        public Builder addDefinitionClass(Class definitionClass) {
            this.definitionClasses.add(definitionClass);
            return this;
        }

        public Builder addDefinitionClasses(Collection<Class> definitionClasses) {
            this.definitionClasses.addAll(definitionClasses);
            return this;
        }

        public Builder setIgnoreInvalidDefinitions(boolean ignoreInvalidDefinitions) {
            this.ignoreInvalidDefinitions = ignoreInvalidDefinitions;
            return this;
        }

        public Builder setIgnoreInvalidExperiments(boolean ignoreInvalidExperiments) {
            this.ignoreInvalidExperiments = ignoreInvalidExperiments;
            return this;
        }

        public Builder setIgnoreInvocationExceptions(boolean ignoreInvocationExceptions) {
            this.ignoreInvocationExceptions = ignoreInvocationExceptions;
            return this;
        }

        public ExperimentEngineConfig build() {
            return new ExperimentEngineConfigImpl(this);
        }
    }
}

