/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.core;

import java.io.InputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.craftsmenlabs.gareth.api.ExperimentEngine;
import org.craftsmenlabs.gareth.api.ExperimentEngineConfig;
import org.craftsmenlabs.gareth.api.context.ExperimentContext;
import org.craftsmenlabs.gareth.api.context.ExperimentRunContext;
import org.craftsmenlabs.gareth.api.definition.ParsedDefinition;
import org.craftsmenlabs.gareth.api.definition.ParsedDefinitionFactory;
import org.craftsmenlabs.gareth.api.exception.GarethDefinitionParseException;
import org.craftsmenlabs.gareth.api.exception.GarethExperimentParseException;
import org.craftsmenlabs.gareth.api.exception.GarethStateReadException;
import org.craftsmenlabs.gareth.api.exception.GarethUnknownExperimentException;
import org.craftsmenlabs.gareth.api.factory.ExperimentFactory;
import org.craftsmenlabs.gareth.api.invoker.MethodDescriptor;
import org.craftsmenlabs.gareth.api.model.Experiment;
import org.craftsmenlabs.gareth.api.observer.Observer;
import org.craftsmenlabs.gareth.api.persist.ExperimentEnginePersistence;
import org.craftsmenlabs.gareth.api.registry.DefinitionRegistry;
import org.craftsmenlabs.gareth.api.registry.ExperimentRegistry;
import org.craftsmenlabs.gareth.api.rest.RestService;
import org.craftsmenlabs.gareth.api.rest.RestServiceFactory;
import org.craftsmenlabs.gareth.api.storage.StorageFactory;
import org.craftsmenlabs.gareth.core.ExperimentContextBuilder;
import org.craftsmenlabs.gareth.core.ExperimentEngineImplBuilder;
import org.craftsmenlabs.gareth.core.ExperimentRunner;
import org.craftsmenlabs.gareth.core.context.ExperimentRunContextImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentEngineImpl
implements ExperimentEngine {
    private static final Logger logger = LoggerFactory.getLogger(ExperimentEngineImpl.class);
    private final DefinitionRegistry definitionRegistry;
    private final ParsedDefinitionFactory parsedDefinitionFactory;
    private final ExperimentFactory experimentFactory;
    private final ExperimentRegistry experimentRegistry;
    private final ExperimentEngineConfig experimentEngineConfig;
    private final List<ExperimentContext> experimentContexts = new ArrayList<ExperimentContext>();
    private final List<ExperimentRunContext> experimentRunContexts = new ArrayList<ExperimentRunContext>();
    private final RestServiceFactory restServiceFactory;
    private final StorageFactory storageFactory;
    private final ExperimentEnginePersistence experimentEnginePersistence;
    private final Observer observer;
    private ExperimentContextBuilder experimentContextBuilder;
    private ExperimentRunner experimentRunner;
    private boolean started;

    ExperimentEngineImpl(ExperimentEngineImplBuilder builder) {
        this.experimentEngineConfig = builder.experimentEngineConfig;
        this.definitionRegistry = builder.definitionRegistry;
        this.parsedDefinitionFactory = builder.parsedDefinitionFactory;
        this.experimentFactory = builder.experimentFactory;
        this.experimentRegistry = builder.experimentRegistry;
        this.restServiceFactory = builder.restServiceFactory;
        this.storageFactory = builder.storageFactory;
        this.experimentEnginePersistence = builder.experimentEnginePersistence;
        this.observer = builder.observer;
        this.experimentContextBuilder = new ExperimentContextBuilder(this.definitionRegistry, this.experimentEngineConfig);
        this.experimentRunner = new ExperimentRunner(builder.methodInvoker, builder.assumeScheduler, this.experimentEngineConfig.isIgnoreInvocationExceptions());
    }

    private void registerDefinition(Class clazz) throws GarethDefinitionParseException {
        ParsedDefinition parsedDefinition = this.parsedDefinitionFactory.parse(clazz);
        this.addParsedDefinitionToRegistry(parsedDefinition);
    }

    private void registerExperiment(InputStream inputStream) {
        Experiment experiment = this.experimentFactory.buildExperiment(inputStream);
        this.experimentRegistry.addExperiment(experiment.getExperimentName(), experiment);
    }

    @Override
    public void start() {
        if (this.isStarted()) {
            throw new IllegalStateException("Experiment engine already started");
        }
        this.started = true;
        logger.info("Starting experiment engine");
        this.init();
        this.startRestService();
        this.runExperiments();
    }

    @Override
    public void stop() {
        if (!this.isStarted()) {
            throw new IllegalStateException("Experiment engine is not started");
        }
        this.observer.notifyApplicationStateChanged(this);
    }

    private void init() {
        logger.info("Initializing experiment engine");
        this.initDefinitions();
        this.initExperiments();
        this.experimentContexts.addAll(this.experimentContextBuilder.build(this.experimentRegistry.getAllExperiments()));
        this.loadStateFromPersistence();
    }

    private void loadStateFromPersistence() {
        if (null != this.experimentEnginePersistence) {
            try {
                this.experimentEnginePersistence.restore(this);
            }
            catch (GarethStateReadException garethStateReadException) {
                // empty catch block
            }
        }
    }

    private void startRestService() {
        if (null != this.restServiceFactory) {
            try {
                logger.info("Starting REST service");
                RestService restService = this.restServiceFactory.create(this, 8888);
                restService.start();
            }
            catch (Exception e) {
                logger.error("REST service cannot be started", e);
            }
        }
    }

    @Override
    public String runExperiment(Experiment experiment) {
        this.experimentRegistry.addExperiment(experiment.getExperimentName(), experiment);
        ExperimentContext context = this.experimentContextBuilder.build(experiment);
        this.experimentContexts.add(context);
        ExperimentRunContext experimentRunContext = new ExperimentRunContextImpl.Builder(context, this.storageFactory.createStorage()).build();
        this.experimentRunContexts.add(experimentRunContext);
        this.planExperimentRunContext(experimentRunContext);
        return experimentRunContext.getHash();
    }

    private void runExperiments() {
        logger.info("Run and schedule experiments");
        for (ExperimentContext experimentContext : this.experimentContexts) {
            if (!this.isNewExperimentRunContextNeeded(experimentContext.getHash())) continue;
            ExperimentRunContext experimentRunContext = new ExperimentRunContextImpl.Builder(experimentContext, this.storageFactory.createStorage()).build();
            this.experimentRunContexts.add(experimentRunContext);
        }
        this.getExperimentRunContexts().forEach(erc -> this.planExperimentRunContext((ExperimentRunContext)erc));
    }

    private boolean isNewExperimentRunContextNeeded(String hash) {
        return this.getExperimentRunContexts().stream().filter(erc -> hash.equals(erc.getHash())).count() == 0L;
    }

    @Override
    public void planExperimentContext(ExperimentContext experimentContext) {
        ExperimentRunContext experimentRunContext = new ExperimentRunContextImpl.Builder(experimentContext, this.storageFactory.createStorage()).build();
        this.experimentRunContexts.add(experimentRunContext);
        this.planExperimentRunContext(experimentRunContext);
    }

    public void planExperimentRunContext(ExperimentRunContext experimentRunContext) {
        if (!this.isStarted()) {
            throw new IllegalStateException("Cannot plan experiment context when engine is not started");
        }
        if (experimentRunContext.getExperimentContext().isValid()) {
            this.experimentRunner.invokeBaseline(experimentRunContext, () -> this.observer.notifyApplicationStateChanged(this));
            this.experimentRunner.scheduleInvokeAssume(experimentRunContext, this);
            experimentRunContext.setFinished(true);
        }
    }

    @Override
    public List<ExperimentRunContext> findExperimentRunContextsForHash(String hash) {
        if (hash == null) {
            throw new IllegalArgumentException("Hash cannot be null");
        }
        return this.getExperimentRunContexts().stream().filter(erc -> hash.equals(erc.getHash())).collect(Collectors.toList());
    }

    @Override
    public ExperimentContext findExperimentContextForHash(String hash) throws GarethUnknownExperimentException {
        if (!this.isStarted()) {
            throw new IllegalStateException("Cannot plan experiment context when engine is not started");
        }
        if (hash == null) {
            throw new IllegalArgumentException("Hash cannot be null");
        }
        Optional<ExperimentContext> experimentContext = this.experimentContexts.stream().filter(ec -> ec.getHash().equals(hash)).findFirst();
        return experimentContext.orElseThrow(() -> new GarethUnknownExperimentException("Cannot find experiment context for hash"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initExperiments() throws GarethExperimentParseException {
        for (InputStream inputStream : this.experimentEngineConfig.getInputStreams()) {
            try {
                this.registerExperiment(inputStream);
            }
            catch (GarethExperimentParseException e) {
                if (this.experimentEngineConfig.isIgnoreInvalidExperiments()) continue;
                throw e;
            }
            finally {
                IOUtils.closeQuietly(inputStream);
            }
        }
    }

    private void initDefinitions() {
        for (Class clazz : this.experimentEngineConfig.getDefinitionClasses()) {
            try {
                this.registerDefinition(clazz);
            }
            catch (GarethDefinitionParseException e) {
                if (this.experimentEngineConfig.isIgnoreInvalidDefinitions()) continue;
                throw e;
            }
        }
    }

    private void addParsedDefinitionToRegistry(ParsedDefinition parsedDefinition) {
        parsedDefinition.getBaselineDefinitions().forEach((k, v) -> this.definitionRegistry.addMethodDescriptorForBaseline((String)k, (MethodDescriptor)v));
        parsedDefinition.getAssumeDefinitions().forEach((k, v) -> this.definitionRegistry.addMethodDescriptorForAssume((String)k, (MethodDescriptor)v));
        parsedDefinition.getFailureDefinitions().forEach((k, v) -> this.definitionRegistry.addMethodDescriptorForFailure((String)k, (MethodDescriptor)v));
        parsedDefinition.getSuccessDefinitions().forEach((k, v) -> this.definitionRegistry.addMethodDescriptorForSuccess((String)k, (MethodDescriptor)v));
        parsedDefinition.getTimeDefinitions().forEach((k, v) -> this.definitionRegistry.addDurationForTime((String)k, (Duration)v));
    }

    @Override
    public DefinitionRegistry getDefinitionRegistry() {
        return this.definitionRegistry;
    }

    @Override
    public List<ExperimentContext> getExperimentContexts() {
        return this.experimentContexts;
    }

    @Override
    public List<ExperimentRunContext> getExperimentRunContexts() {
        return this.experimentRunContexts;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }
}

