/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.core;

import org.craftsmenlabs.gareth.api.ExperimentEngine;
import org.craftsmenlabs.gareth.api.ExperimentEngineConfig;
import org.craftsmenlabs.gareth.api.definition.ParsedDefinitionFactory;
import org.craftsmenlabs.gareth.api.factory.ExperimentFactory;
import org.craftsmenlabs.gareth.api.invoker.MethodInvoker;
import org.craftsmenlabs.gareth.api.observer.Observer;
import org.craftsmenlabs.gareth.api.persist.ExperimentEnginePersistence;
import org.craftsmenlabs.gareth.api.registry.DefinitionRegistry;
import org.craftsmenlabs.gareth.api.registry.ExperimentRegistry;
import org.craftsmenlabs.gareth.api.rest.RestServiceFactory;
import org.craftsmenlabs.gareth.api.scheduler.AssumeScheduler;
import org.craftsmenlabs.gareth.api.storage.StorageFactory;
import org.craftsmenlabs.gareth.core.ExperimentEngineImpl;
import org.craftsmenlabs.gareth.core.factory.ExperimentFactoryImpl;
import org.craftsmenlabs.gareth.core.invoker.MethodInvokerImpl;
import org.craftsmenlabs.gareth.core.observer.DefaultObserver;
import org.craftsmenlabs.gareth.core.parser.ParsedDefinitionFactoryImpl;
import org.craftsmenlabs.gareth.core.persist.FileSystemExperimentEnginePersistence;
import org.craftsmenlabs.gareth.core.reflection.DefinitionFactory;
import org.craftsmenlabs.gareth.core.reflection.ReflectionHelper;
import org.craftsmenlabs.gareth.core.registry.DefinitionRegistryImpl;
import org.craftsmenlabs.gareth.core.registry.ExperimentRegistryImpl;
import org.craftsmenlabs.gareth.core.scheduler.DefaultAssumeScheduler;
import org.craftsmenlabs.gareth.core.storage.DefaultStorageFactory;

public class ExperimentEngineImplBuilder {
    final ExperimentEngineConfig experimentEngineConfig;
    DefinitionRegistry definitionRegistry = new DefinitionRegistryImpl();
    DefinitionFactory customDefinitionFactory;
    ReflectionHelper reflectionHelper;
    ParsedDefinitionFactory parsedDefinitionFactory;
    MethodInvoker methodInvoker;
    ExperimentFactory experimentFactory = new ExperimentFactoryImpl();
    ExperimentRegistry experimentRegistry = new ExperimentRegistryImpl();
    AssumeScheduler assumeScheduler = null;
    RestServiceFactory restServiceFactory;
    StorageFactory storageFactory = new DefaultStorageFactory();
    Observer observer = new DefaultObserver();
    ExperimentEnginePersistence experimentEnginePersistence = new FileSystemExperimentEnginePersistence.Builder().build();

    public ExperimentEngineImplBuilder(ExperimentEngineConfig experimentEngineConfig) {
        this.experimentEngineConfig = experimentEngineConfig;
    }

    public ExperimentEngineImplBuilder setDefinitionRegistry(DefinitionRegistry definitionRegistry) {
        this.definitionRegistry = definitionRegistry;
        return this;
    }

    public ExperimentEngineImplBuilder setParsedDefinitionFactory(ParsedDefinitionFactory parsedDefinitionFactory) {
        this.parsedDefinitionFactory = parsedDefinitionFactory;
        return this;
    }

    public ExperimentEngineImplBuilder setExperimentRegistry(ExperimentRegistry experimentRegistry) {
        this.experimentRegistry = experimentRegistry;
        return this;
    }

    public ExperimentEngineImplBuilder setMethodInvoker(MethodInvoker methodInvoker) {
        this.methodInvoker = methodInvoker;
        return this;
    }

    public ExperimentEngineImplBuilder setExperimentFactory(ExperimentFactory experimentFactory) {
        this.experimentFactory = experimentFactory;
        return this;
    }

    public ExperimentEngineImplBuilder setStorageFactory(StorageFactory storageFactory) {
        this.storageFactory = storageFactory;
        return this;
    }

    public ExperimentEngineImplBuilder setRestServiceFactory(RestServiceFactory restServiceFactory) {
        this.restServiceFactory = restServiceFactory;
        return this;
    }

    public ExperimentEngineImplBuilder setExperimentEnginePersistence(ExperimentEnginePersistence experimentEnginePersistence) {
        this.experimentEnginePersistence = experimentEnginePersistence;
        return this;
    }

    public ExperimentEngineImplBuilder setAssumeScheduler(AssumeScheduler assumeScheduler) {
        this.assumeScheduler = assumeScheduler;
        return this;
    }

    public ExperimentEngineImplBuilder addCustomDefinitionFactory(DefinitionFactory definitionFactory) {
        this.customDefinitionFactory = definitionFactory;
        return this;
    }

    public ExperimentEngine build() {
        this.reflectionHelper = new ReflectionHelper(this.customDefinitionFactory);
        this.builParsedDefinitionFactory();
        this.builMethodInvoker();
        this.registerObservables();
        this.buildDefaultAssumeScheduler();
        return new ExperimentEngineImpl(this);
    }

    private void builParsedDefinitionFactory() {
        if (this.parsedDefinitionFactory == null) {
            this.parsedDefinitionFactory = new ParsedDefinitionFactoryImpl(this.reflectionHelper);
        }
    }

    private void builMethodInvoker() {
        if (this.methodInvoker == null) {
            this.methodInvoker = new MethodInvokerImpl(this.reflectionHelper);
        }
    }

    private void buildDefaultAssumeScheduler() {
        if (this.assumeScheduler == null) {
            this.assumeScheduler = new DefaultAssumeScheduler.Builder(this.observer).addCustomDefinitionFactory(this.customDefinitionFactory).setIgnoreInvocationExceptions(this.experimentEngineConfig.isIgnoreInvocationExceptions()).build();
        }
    }

    private void registerObservables() {
        if (null != this.experimentEnginePersistence) {
            this.observer.registerExperimentStateChangeListener(this.experimentEnginePersistence.getExperimentStateChangeListener());
        }
    }
}

