/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.core;

import java.time.LocalDateTime;
import org.craftsmenlabs.gareth.api.ExperimentEngine;
import org.craftsmenlabs.gareth.api.context.ExperimentPartState;
import org.craftsmenlabs.gareth.api.context.ExperimentRunContext;
import org.craftsmenlabs.gareth.api.exception.GarethInvocationException;
import org.craftsmenlabs.gareth.api.exception.GarethUnknownDefinitionException;
import org.craftsmenlabs.gareth.api.invoker.MethodDescriptor;
import org.craftsmenlabs.gareth.api.invoker.MethodInvoker;
import org.craftsmenlabs.gareth.api.scheduler.AssumeScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentRunner {
    private static Logger logger = LoggerFactory.getLogger(ExperimentRunner.class);
    private MethodInvoker methodInvoker;
    private AssumeScheduler assumeScheduler;
    private boolean ignoreInvocationExceptions;

    public ExperimentRunner(MethodInvoker methodInvoker, AssumeScheduler assumeScheduler, boolean ignoreInvocationExceptions) {
        this.methodInvoker = methodInvoker;
        this.assumeScheduler = assumeScheduler;
        this.ignoreInvocationExceptions = ignoreInvocationExceptions;
    }

    void invokeBaseline(ExperimentRunContext runContext, Informer onStateChange) {
        String glueLineInExperiment = runContext.getExperimentContext().getBaselineGlueLine();
        logger.debug(String.format("Invoking baseline: %s with state %s", glueLineInExperiment, runContext.getBaselineState().getName()));
        if (ExperimentPartState.OPEN == runContext.getBaselineState()) {
            block5: {
                try {
                    runContext.setBaselineState(ExperimentPartState.RUNNING);
                    MethodDescriptor baseline = runContext.getExperimentContext().getBaseline();
                    if (runContext.getExperimentContext().hasStorage()) {
                        this.methodInvoker.invoke(glueLineInExperiment, baseline, runContext.getStorage());
                    } else {
                        this.methodInvoker.invoke(glueLineInExperiment, baseline);
                    }
                    runContext.setBaselineState(ExperimentPartState.FINISHED);
                    runContext.setBaselineRun(LocalDateTime.now());
                }
                catch (GarethInvocationException | GarethUnknownDefinitionException e) {
                    runContext.setBaselineState(ExperimentPartState.ERROR);
                    if (this.ignoreInvocationExceptions) break block5;
                    throw e;
                }
            }
            onStateChange.invoke();
        }
    }

    void scheduleInvokeAssume(ExperimentRunContext experimentRunContext, ExperimentEngine engine) {
        block3: {
            if (ExperimentPartState.OPEN == experimentRunContext.getAssumeState()) {
                try {
                    this.assumeScheduler.schedule(experimentRunContext, engine);
                }
                catch (GarethInvocationException | GarethUnknownDefinitionException e) {
                    if (this.ignoreInvocationExceptions) break block3;
                    throw e;
                }
            }
        }
    }

    @FunctionalInterface
    public static interface Informer {
        public void invoke();
    }
}

