/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.core.invoker;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.craftsmenlabs.gareth.api.invoker.MethodDescriptor;
import org.craftsmenlabs.gareth.api.storage.Storage;
import org.craftsmenlabs.gareth.core.invoker.RegexAnnotatedMethodAdapter;

public class RegexMethodDescriptorImpl
implements MethodDescriptor {
    private final RegexAnnotatedMethodAdapter methodAdapter;
    private final int storageParameterIndex;
    private final boolean storageParameter;

    public RegexMethodDescriptorImpl(String glueLine, Method method, int storageParameterIndex, boolean storageParameter) {
        this.methodAdapter = new RegexAnnotatedMethodAdapter(method, glueLine);
        this.storageParameterIndex = storageParameterIndex;
        this.storageParameter = storageParameter;
    }

    @Override
    public Method getMethod() {
        return this.methodAdapter.getMethod();
    }

    @Override
    public boolean hasStorage() {
        return this.storageParameter;
    }

    @Override
    public int getStorageIndex() {
        return this.storageParameterIndex;
    }

    @Override
    public void invokeWith(String glueLineInExperiment, Object declaringClassInstance, Storage storage) throws InvocationTargetException, IllegalAccessException {
        ArrayList<Object> arguments = new ArrayList<Object>();
        if (this.hasStorage()) {
            arguments.add(storage);
        }
        List<Object> argumentValuesFromInputString = this.methodAdapter.getArgumentValuesFromInputString(glueLineInExperiment);
        arguments.addAll(argumentValuesFromInputString);
        this.methodAdapter.invokeWith(declaringClassInstance, arguments);
    }

    @Override
    public String getRegexPatternForGlueLine() {
        return this.methodAdapter.getPattern();
    }
}

