/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.core.parser;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.craftsmenlabs.gareth.api.model.GlueLineType;

public class GlueLineMatcher {
    private Map<GlueLineType, Set<String>> glueLinesPerCategory;

    public void init(Map<GlueLineType, Set<String>> model) {
        this.glueLinesPerCategory = Maps.newHashMap(model);
        HashSet<String> expandedTimeGlueLines = new HashSet<String>((Collection)model.get((Object)GlueLineType.TIME));
        expandedTimeGlueLines.addAll(this.timeGlueLines());
        this.glueLinesPerCategory.put(GlueLineType.TIME, expandedTimeGlueLines);
    }

    public Optional<GlueLineType> getGlueLineType(String key) {
        return GlueLineType.safeValueOf(key == null ? null : key.trim().toUpperCase());
    }

    public Map<String, List<String>> getMatches(String glueLineType, String line) {
        if (line == null || line.isEmpty()) {
            return Collections.emptyMap();
        }
        Set<String> patternsPerGlueLineType = this.glueLinesPerCategory.get((Object)this.getGlueLineType(glueLineType).get());
        HashMap<String, List<String>> output = new HashMap<String, List<String>>();
        output.put("suggestions", this.getMatchingGlueLines(patternsPerGlueLineType, p -> p.contains(line) || this.isPartialMatch((String)p, line)));
        output.put("matches", this.getMatchingGlueLines(patternsPerGlueLineType, p -> this.isFullMatch((String)p, line)));
        return output;
    }

    private List<String> getMatchingGlueLines(Set<String> patterns, Predicate<String> filter) {
        return patterns.stream().filter(filter).map(p -> this.convertRegexToHumanReadable((String)p)).collect(Collectors.toList());
    }

    private String convertRegexToHumanReadable(String pattern) {
        return pattern.replaceAll("^\\^", "").replaceAll("\\$$", "").replaceAll("\\(.+?\\)", "*");
    }

    private boolean isFullMatch(String pattern, String test) {
        return this.matchType(pattern, test) == 2;
    }

    private boolean isPartialMatch(String pattern, String test) {
        return this.matchType(pattern, test) >= 1;
    }

    private int matchType(String pattern, String test) {
        Pattern compile = Pattern.compile(pattern);
        Matcher matcher = compile.matcher(test);
        if (matcher.matches()) {
            return 2;
        }
        if (matcher.hitEnd()) {
            return 1;
        }
        return 0;
    }

    private List<String> timeGlueLines() {
        return Lists.newArrayList("^(\\d+) seconds?$", "^(\\d+) minutes?$", "^(\\d+) hours?$", "^(\\d+) days?$", "^(\\d+) weeks?$", "^(\\d+) months?$", "^(\\d+) years?$");
    }
}

