/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.examples;

import org.craftsmenlabs.gareth.api.ExperimentEngine;
import org.craftsmenlabs.gareth.api.ExperimentEngineConfig;
import org.craftsmenlabs.gareth.api.persist.ExperimentEnginePersistence;
import org.craftsmenlabs.gareth.core.ExperimentEngineConfigImpl;
import org.craftsmenlabs.gareth.core.ExperimentEngineImplBuilder;
import org.craftsmenlabs.gareth.core.persist.FileSystemExperimentEnginePersistence;
import org.craftsmenlabs.gareth.examples.definition.SampleDefinition;

public class ExampleApplication {
    public static void main(String[] args) {
        ExperimentEnginePersistence experimentEnginePersistence = new FileSystemExperimentEnginePersistence.Builder().build();
        ExperimentEngineConfig experimentEngineConfig = new ExperimentEngineConfigImpl.Builder().addDefinitionClass(SampleDefinition.class).addInputStreams(ExampleApplication.class.getClass().getResourceAsStream("/experiments/businessgoal-01.experiment")).setIgnoreInvocationExceptions(false).build();
        ExperimentEngine experimentEngine = new ExperimentEngineImplBuilder(experimentEngineConfig).setExperimentEnginePersistence(experimentEnginePersistence).build();
        experimentEngine.start();
        Runtime.getRuntime().addShutdownHook(new ShutdownHook(experimentEngine));
    }

    static class ShutdownHook
    extends Thread {
        private final ExperimentEngine experimentEngine;

        private ShutdownHook(ExperimentEngine experimentEngine) {
            this.experimentEngine = experimentEngine;
        }

        @Override
        public void run() {
            this.experimentEngine.stop();
        }
    }
}

