/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.rest;

import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.craftsmenlabs.gareth.api.ExperimentEngine;
import org.craftsmenlabs.gareth.api.rest.RestService;
import org.craftsmenlabs.gareth.rest.GarethApplication;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;

public class RestServiceImpl
implements RestService {
    private final int portNumber;
    private final String uri;
    private final ExperimentEngine experimentEngine;

    private RestServiceImpl(Builder builder) {
        this.portNumber = builder.portNumber;
        this.uri = builder.uri;
        this.experimentEngine = builder.experimentEngine;
    }

    public void start() throws Exception {
        URI baseUri = UriBuilder.fromUri((String)this.uri).port(this.portNumber).build(new Object[0]);
        HttpServer server = GrizzlyHttpServerFactory.createHttpServer((URI)baseUri, (ResourceConfig)new GarethApplication(this.experimentEngine));
        server.start();
    }

    public static class Builder {
        private int portNumber = 8080;
        private String uri = "http://localhost/";
        private ExperimentEngine experimentEngine;

        public Builder setExperimentEngine(ExperimentEngine experimentEngine) {
            this.experimentEngine = experimentEngine;
            return this;
        }

        public Builder setPortNumber(int portNumber) {
            this.portNumber = portNumber;
            return this;
        }

        public Builder setURI(String uri) {
            this.uri = uri;
            return this;
        }

        public RestService build() {
            return new RestServiceImpl(this);
        }
    }
}

