/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.rest.resource;

import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.craftsmenlabs.gareth.api.ExperimentEngine;
import org.craftsmenlabs.gareth.api.context.ExperimentContext;
import org.craftsmenlabs.gareth.api.exception.GarethUnknownExperimentException;

@Path(value="/experiments-rerun")
public class ExperimentRerunResource {
    @Inject
    private ExperimentEngine experimentEngine;

    @GET
    @Path(value="{hash}")
    public Response rerunExperiment(@PathParam(value="hash") String hash) {
        Response response = null;
        try {
            ExperimentContext experimentContext = this.experimentEngine.findExperimentContextForHash(hash);
            this.experimentEngine.planExperimentContext(experimentContext);
            response = Response.accepted().build();
        }
        catch (GarethUnknownExperimentException e) {
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return response;
    }
}

