/*
 * Decompiled with CFR 0.152.
 */
package org.craftsmenlabs.gareth.rest.resource;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import org.craftsmenlabs.gareth.api.ExperimentEngine;
import org.craftsmenlabs.gareth.api.context.ExperimentRunContext;
import org.craftsmenlabs.gareth.rest.v1.assembler.ExperimentRunAssembler;
import org.craftsmenlabs.gareth.rest.v1.entity.ExperimentRun;

@Path(value="/experimentruns")
public class ExperimentRunResource {
    @Inject
    private ExperimentEngine experimentEngine;

    @GET
    @Produces(value={"application/vnd+org.craftsmenlabs.gareth.experimentruns-v1+json", "application/json"})
    @Path(value="{hash}")
    public Response get(@PathParam(value="hash") String hash) {
        return Response.status((int)200).entity((Object)new GenericEntity<List<ExperimentRun>>(this.assembleExperiments(this.experimentEngine.findExperimentRunContextsForHash(hash))){}).build();
    }

    private List<ExperimentRun> assembleExperiments(List<ExperimentRunContext> experimentRunContexts) {
        ExperimentRunAssembler assembler = new ExperimentRunAssembler();
        ArrayList<ExperimentRun> experimentRuns = new ArrayList<ExperimentRun>();
        for (ExperimentRunContext experimentRunContext : experimentRunContexts) {
            experimentRuns.add((ExperimentRun)assembler.assembleOutbound(experimentRunContext));
        }
        return experimentRuns;
    }
}

