/*
 * Decompiled with CFR 0.152.
 */
package org.crazycake.ScaffoldUnit;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.codehaus.jackson.map.ObjectMapper;
import org.crazycake.ScaffoldUnit.dao.ScaffoldUnitDao;
import org.crazycake.ScaffoldUnit.model.SCol;
import org.crazycake.ScaffoldUnit.model.SMethod;
import org.crazycake.ScaffoldUnit.model.STable;
import org.crazycake.ScaffoldUnit.model.Sconf;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScaffoldUnit {
    private static ObjectMapper mapper = new ObjectMapper();
    private static Logger logger = LoggerFactory.getLogger(ScaffoldUnit.class);
    private static ScaffoldUnitDao dao = new ScaffoldUnitDao();

    private static void buildIt() throws IOException, SQLException {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StackTraceElement s = stackTraceElements[3];
        String callerClassFullName = s.getClassName();
        String callerClassName = callerClassFullName.substring(callerClassFullName.lastIndexOf(".") + 1, callerClassFullName.length());
        Sconf sconf = null;
        try {
            sconf = (Sconf)mapper.readValue(Class.forName(callerClassFullName).getResourceAsStream(String.valueOf(callerClassName) + ".json"), Sconf.class);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (sconf == null) {
            return;
        }
        List<SMethod> ms = sconf.getMs();
        if (ms == null || ms.size() == 0) {
            return;
        }
        SMethod smethod = ScaffoldUnit.findMethod(s, ms);
        if (smethod == null) {
            return;
        }
        List<STable> ts = smethod.getTs();
        if (ts == null || ts.size() == 0) {
            return;
        }
        ScaffoldUnit.cleanTables(ts);
        ScaffoldUnit.initialTables(ts);
    }

    private static SMethod findMethod(StackTraceElement s, List<SMethod> ms) {
        String methodName = s.getMethodName();
        SMethod smethod = null;
        for (SMethod m : ms) {
            if (!methodName.equals(m.getN())) continue;
            smethod = m;
            break;
        }
        return smethod;
    }

    public static void build() throws IOException, SQLException {
        ScaffoldUnit.buildIt();
    }

    public static void dbAssertThat(String sql, Matcher matcher) throws SQLException {
        Object actual = dao.queryOneValue(sql);
        Assert.assertThat((String)sql, (Object)actual, (Matcher)matcher);
    }

    private static void initialTables(List<STable> ts) throws IOException, SQLException {
        for (STable t : ts) {
            List<List<SCol>> rs = t.getRs();
            if (rs == null || rs.size() == 0) continue;
            ScaffoldUnit.insertRows(t, rs);
        }
    }

    private static void insertRows(STable t, List<List<SCol>> rs) throws IOException, SQLException {
        int i = 0;
        while (i < rs.size()) {
            List<SCol> cs = rs.get(i);
            if (cs != null && cs.size() != 0) {
                ScaffoldUnit.insertRow(t.getT(), cs);
            }
            ++i;
        }
    }

    private static void insertRow(String t, List<SCol> cs) throws IOException, SQLException {
        StringBuilder fields = new StringBuilder();
        fields.append("(");
        StringBuilder values = new StringBuilder();
        values.append("(");
        int j = 0;
        while (j < cs.size()) {
            SCol c = cs.get(j);
            if (j != 0) {
                fields.append(",");
                values.append(",");
            }
            fields.append(c.getC());
            values.append(c.getV());
            if (j == cs.size() - 1) {
                fields.append(")");
                values.append(")");
            }
            ++j;
        }
        String insertSql = "insert into " + t + " " + fields.toString() + " values " + values.toString();
        dao.execute(insertSql);
    }

    private static void cleanTables(List<STable> ts) throws IOException, SQLException {
        for (STable t : ts) {
            dao.execute("truncate table " + t.getT());
        }
    }

    public static void wtf() throws IOException, SQLException {
        System.out.println("ScaffoldUnit said: \"wtf!\"");
        ScaffoldUnit.buildIt();
    }

    public static void iHateWorkOvertime() throws IOException, SQLException {
        System.out.println("ScaffoldUnit said: \"I hate work overtime!\"");
        ScaffoldUnit.buildIt();
    }

    public static void comeAndBiteMe() throws IOException, SQLException {
        System.out.println("ScaffoldUnit said: \"Come and bite me!\"");
        ScaffoldUnit.buildIt();
    }

    public static void screwU() throws IOException, SQLException {
        System.out.println("ScaffoldUnit said: \"Screw U!\"");
        ScaffoldUnit.buildIt();
    }

    public static void myBossIsAMuggle() throws IOException, SQLException {
        System.out.println("ScaffoldUnit said: \"My boss is a muggle!\"");
        ScaffoldUnit.buildIt();
    }
}

