/*
 * Decompiled with CFR 0.152.
 */
package org.crazycake.ScaffoldUnit.utils;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptRunner {
    private static final String DEFAULT_DELIMITER = ";";
    private Connection connection;
    private boolean stopOnError;
    private boolean autoCommit;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String delimiter = ";";
    private boolean fullLineDelimiter = false;

    public ScriptRunner(Connection connection, boolean autoCommit, boolean stopOnError) {
        this.connection = connection;
        this.autoCommit = autoCommit;
        this.stopOnError = stopOnError;
    }

    public void setDelimiter(String delimiter, boolean fullLineDelimiter) {
        this.delimiter = delimiter;
        this.fullLineDelimiter = fullLineDelimiter;
    }

    public void runScript(Reader reader) throws IOException, SQLException {
        try {
            boolean originalAutoCommit = this.connection.getAutoCommit();
            try {
                if (originalAutoCommit != this.autoCommit) {
                    this.connection.setAutoCommit(this.autoCommit);
                }
                this.runScript(this.connection, reader);
            }
            finally {
                this.connection.setAutoCommit(originalAutoCommit);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error running script.  Cause: " + e, e);
        }
    }

    private void runScript(Connection conn, Reader reader) throws IOException, SQLException {
        StringBuffer command = null;
        try {
            try {
                LineNumberReader lineReader = new LineNumberReader(reader);
                String line = null;
                while ((line = lineReader.readLine()) != null) {
                    String trimmedLine;
                    if (command == null) {
                        command = new StringBuffer();
                    }
                    if ((trimmedLine = line.trim()).startsWith("--")) {
                        this.println(trimmedLine);
                        continue;
                    }
                    if (trimmedLine.length() < 1 || trimmedLine.startsWith("//") || trimmedLine.length() < 1 || trimmedLine.startsWith("--")) continue;
                    if (!this.fullLineDelimiter && trimmedLine.endsWith(this.getDelimiter()) || this.fullLineDelimiter && trimmedLine.equals(this.getDelimiter())) {
                        command.append(line.substring(0, line.lastIndexOf(this.getDelimiter())));
                        command.append(" ");
                        Statement statement = conn.createStatement();
                        this.println(command);
                        boolean hasResults = false;
                        if (this.stopOnError) {
                            hasResults = statement.execute(command.toString());
                        } else {
                            try {
                                statement.execute(command.toString());
                            }
                            catch (SQLException e) {
                                e.fillInStackTrace();
                                this.printlnError("Error executing: " + command);
                                this.printlnError(e);
                            }
                        }
                        if (this.autoCommit && !conn.getAutoCommit()) {
                            conn.commit();
                        }
                        ResultSet rs = statement.getResultSet();
                        if (hasResults && rs != null) {
                            ResultSetMetaData md = rs.getMetaData();
                            int cols = md.getColumnCount();
                            int i = 0;
                            while (i < cols) {
                                String name = md.getColumnLabel(i);
                                this.print(String.valueOf(name) + "\t");
                                ++i;
                            }
                            this.println("");
                            while (rs.next()) {
                                i = 0;
                                while (i < cols) {
                                    String value = rs.getString(i);
                                    this.print(String.valueOf(value) + "\t");
                                    ++i;
                                }
                                this.println("");
                            }
                        }
                        command = null;
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        Thread.yield();
                        continue;
                    }
                    command.append(line);
                    command.append(" ");
                }
                if (!this.autoCommit) {
                    conn.commit();
                }
            }
            catch (SQLException e) {
                e.fillInStackTrace();
                this.printlnError("Error executing: " + command);
                this.printlnError(e);
                throw e;
            }
            catch (IOException e) {
                e.fillInStackTrace();
                this.printlnError("Error executing: " + command);
                this.printlnError(e);
                throw e;
            }
        }
        finally {
            conn.rollback();
        }
    }

    private String getDelimiter() {
        return this.delimiter;
    }

    private void print(Object o) {
        this.logger.debug(o.toString());
    }

    private void println(Object o) {
        this.logger.debug(o.toString());
    }

    private void printlnError(Object o) {
        this.logger.error(o.toString());
    }
}

