/*
 * Decompiled with CFR 0.152.
 */
package org.crazycake.jdbcTemplateTool;

import java.util.List;
import java.util.Map;
import org.crazycake.jdbcTemplateTool.impl.ReturnIdPreparedStatementCreator;
import org.crazycake.jdbcTemplateTool.utils.CatalogUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

public class JdbcTemplateProxy {
    private JdbcTemplate jdbcTemplate;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public <T> List<T> query(String sql, RowMapper<T> rowMapper) throws DataAccessException {
        sql = CatalogUtils.changeCatalog(sql);
        try {
            return this.jdbcTemplate.query(sql, rowMapper);
        }
        catch (DataAccessException e) {
            this.logger.error("Error SQL: " + sql);
            throw e;
        }
    }

    public <T> List<T> query(String sql, Object[] params, RowMapper<T> rowMapper) throws DataAccessException {
        sql = CatalogUtils.changeCatalog(sql);
        try {
            return this.jdbcTemplate.query(sql, params, rowMapper);
        }
        catch (DataAccessException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (Object p : params) {
                sb.append(p + " | ");
            }
            sb.append("]");
            this.logger.error("Error SQL: " + sql + " Params: " + sb.toString());
            throw e;
        }
    }

    public Map<String, Object> queryForMap(String sql) throws DataAccessException {
        sql = CatalogUtils.changeCatalog(sql);
        try {
            return this.jdbcTemplate.queryForMap(sql);
        }
        catch (DataAccessException e) {
            this.logger.error("Error SQL: " + sql);
            throw e;
        }
    }

    public Map<String, Object> queryForMap(String sql, Object[] params) throws DataAccessException {
        sql = CatalogUtils.changeCatalog(sql);
        try {
            return this.jdbcTemplate.queryForMap(sql, params);
        }
        catch (DataAccessException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (Object p : params) {
                sb.append(p + " | ");
            }
            sb.append("]");
            this.logger.error("Error SQL: " + sql + " Params: " + sb.toString());
            throw e;
        }
    }

    public int update(String sql, Object[] params) throws DataAccessException {
        sql = CatalogUtils.changeCatalog(sql);
        try {
            return this.jdbcTemplate.update(sql, params);
        }
        catch (DataAccessException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (Object p : params) {
                sb.append(p + " | ");
            }
            sb.append("]");
            this.logger.error("Error SQL: " + sql + " Params: " + sb.toString());
            throw e;
        }
    }

    public int[] batchUpdate(String sql, BatchPreparedStatementSetter pss) throws DataAccessException {
        sql = CatalogUtils.changeCatalog(sql);
        try {
            return this.jdbcTemplate.batchUpdate(sql, pss);
        }
        catch (DataAccessException e) {
            this.logger.error("Error SQL: " + sql);
            throw e;
        }
    }

    public int insert(String sql, Object[] params, String autoGeneratedColumnName) throws DataAccessException {
        sql = CatalogUtils.changeCatalog(sql);
        ReturnIdPreparedStatementCreator psc = new ReturnIdPreparedStatementCreator(sql, params, autoGeneratedColumnName);
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        try {
            this.jdbcTemplate.update((PreparedStatementCreator)psc, (KeyHolder)keyHolder);
        }
        catch (DataAccessException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (Object p : params) {
                sb.append(p + " | ");
            }
            sb.append("]");
            this.logger.error("Error SQL: " + sql + " Params: " + sb.toString());
            throw e;
        }
        return keyHolder.getKey().intValue();
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

