/*
 * Decompiled with CFR 0.152.
 */
package org.crazycake.jdbcTemplateTool;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.crazycake.jdbcTemplateTool.JdbcTemplateProxy;
import org.crazycake.jdbcTemplateTool.exception.NoColumnAnnotationFoundException;
import org.crazycake.jdbcTemplateTool.exception.NoIdAnnotationFoundException;
import org.crazycake.jdbcTemplateTool.impl.BatchUpdateSetter;
import org.crazycake.jdbcTemplateTool.model.SqlParamsPairs;
import org.crazycake.jdbcTemplateTool.utils.IdUtils;
import org.crazycake.jdbcTemplateTool.utils.ModelSqlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;

public class JdbcTemplateTool {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private JdbcTemplate jdbcTemplate;
    private JdbcTemplateProxy _proxy;

    private JdbcTemplateProxy getProxy() {
        if (this._proxy == null) {
            this._proxy = new JdbcTemplateProxy();
            this._proxy.setJdbcTemplate(this.jdbcTemplate);
        }
        return this._proxy;
    }

    public <T> List<T> list(String sql, Object[] params, Class<T> clazz) {
        List list = null;
        list = params == null || params.length == 0 ? this.getProxy().query(sql, new BeanPropertyRowMapper(clazz)) : this.getProxy().query(sql, params, new BeanPropertyRowMapper(clazz));
        return list;
    }

    public int count(String sql, Object[] params) {
        int rowCount = 0;
        try {
            Map<String, Object> resultMap = null;
            resultMap = params == null || params.length == 0 ? this.getProxy().queryForMap(sql) : this.getProxy().queryForMap(sql, params);
            Iterator<Map.Entry<String, Object>> it = resultMap.entrySet().iterator();
            if (it.hasNext()) {
                Map.Entry<String, Object> entry = it.next();
                rowCount = ((Long)entry.getValue()).intValue();
            }
        }
        catch (EmptyResultDataAccessException e) {
            // empty catch block
        }
        return rowCount;
    }

    public <T> T get(Class clazz, Object id) throws NoIdAnnotationFoundException, NoColumnAnnotationFoundException {
        SqlParamsPairs sqlAndParams = ModelSqlUtils.getGetFromObject(clazz, id);
        List<T> list = this.list(sqlAndParams.getSql(), sqlAndParams.getParams(), clazz);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public void update(Object po) throws Exception {
        SqlParamsPairs sqlAndParams = ModelSqlUtils.getUpdateFromObject(po);
        this.getProxy().update(sqlAndParams.getSql(), sqlAndParams.getParams());
    }

    public void batchUpdate(String sql, List<Object[]> paramsList) {
        BatchUpdateSetter batchUpdateSetter = new BatchUpdateSetter(paramsList);
        this.getProxy().batchUpdate(sql, batchUpdateSetter);
    }

    public void save(Object po) throws Exception {
        String autoGeneratedColumnName = IdUtils.getAutoGeneratedId(po);
        if (!"".equals(autoGeneratedColumnName)) {
            int idValue = this.save(po, autoGeneratedColumnName);
            IdUtils.setAutoIncreamentIdValue(po, autoGeneratedColumnName, idValue);
        } else {
            SqlParamsPairs sqlAndParams = ModelSqlUtils.getInsertFromObject(po);
            this.getProxy().update(sqlAndParams.getSql(), sqlAndParams.getParams());
        }
    }

    private int save(Object po, String autoGeneratedColumnName) throws Exception {
        SqlParamsPairs sqlAndParams = ModelSqlUtils.getInsertFromObject(po);
        String sql = sqlAndParams.getSql();
        return this.getProxy().insert(sql, sqlAndParams.getParams(), autoGeneratedColumnName);
    }

    public void delete(Object po) throws Exception {
        SqlParamsPairs sqlAndParams = ModelSqlUtils.getDeleteFromObject(po);
        String sql = sqlAndParams.getSql();
        this.getProxy().update(sql, sqlAndParams.getParams());
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

