/*
 * Decompiled with CFR 0.152.
 */
package org.crazycake.jdbcTemplateTool.utils;

import org.crazycake.jdbcTemplateTool.model.CatalogContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogUtils {
    private static Logger logger = LoggerFactory.getLogger(CatalogUtils.class);
    private static final ThreadLocal<CatalogContext> catalogContextHolder = new ThreadLocal<CatalogContext>(){};

    public static void setCatalogContext(String placeHolder, String catalog) {
        catalogContextHolder.set(new CatalogContext(placeHolder, catalog));
    }

    public static CatalogContext getCatalogContext() {
        return catalogContextHolder.get();
    }

    public static String changeCatalog(String sql) {
        CatalogContext catalogContext = catalogContextHolder.get();
        if (catalogContext != null && catalogContext.getCatalog() != null && catalogContext.getPlaceHolder() != null) {
            sql = sql.replace(catalogContext.getPlaceHolder(), catalogContext.getCatalog());
        }
        logger.debug("real sql: " + sql);
        return sql;
    }
}

