/*
 * Decompiled with CFR 0.152.
 */
package org.crazycake.jdbcTemplateTool.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.crazycake.jdbcTemplateTool.exception.NoColumnAnnotationFoundException;
import org.crazycake.jdbcTemplateTool.exception.NoIdAnnotationFoundException;
import org.crazycake.jdbcTemplateTool.model.SqlParamsPairs;
import org.crazycake.utils.CamelNameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelSqlUtils {
    private static Logger logger = LoggerFactory.getLogger(ModelSqlUtils.class);

    public static <T> SqlParamsPairs getInsertFromObject(T po) throws Exception {
        StringBuffer insertSql = new StringBuffer();
        StringBuffer paramsSql = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        String tableName = ModelSqlUtils.getTableName(po.getClass());
        insertSql.append("insert into " + tableName + " (");
        int count = 0;
        Field[] fields = po.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Transient tranAnno;
            Object value;
            Method getter;
            Field f = fields[i];
            if ("serialVersionUID".equals(f.getName()) || (getter = ModelSqlUtils.getGetter(po.getClass(), f)) == null || (value = getter.invoke(po, new Object[0])) == null || (tranAnno = getter.getAnnotation(Transient.class)) != null) continue;
            String columnName = ModelSqlUtils.getColumnNameFromGetter(getter, f);
            if (count != 0) {
                insertSql.append(",");
            }
            insertSql.append(columnName);
            if (count != 0) {
                paramsSql.append(",");
            }
            paramsSql.append("?");
            params.add(value);
            ++count;
        }
        insertSql.append(") values (");
        insertSql.append(paramsSql + ")");
        SqlParamsPairs sqlAndParams = new SqlParamsPairs(insertSql.toString(), params.toArray());
        logger.debug(sqlAndParams.toString());
        return sqlAndParams;
    }

    private static <T> Method getGetter(Class<T> clazz, Field f) {
        String getterName = "get" + CamelNameUtils.capitalize((String)f.getName());
        Method getter = null;
        try {
            getter = clazz.getMethod(getterName, new Class[0]);
        }
        catch (Exception e) {
            logger.debug(getterName + " doesn't exist!", (Throwable)e);
        }
        return getter;
    }

    private static <T> String getTableName(Class<T> clazz) {
        Table tableAnno = clazz.getAnnotation(Table.class);
        if (tableAnno != null) {
            if (tableAnno.catalog() != null) {
                return tableAnno.catalog() + "." + tableAnno.name();
            }
            return tableAnno.name();
        }
        String className = clazz.getName();
        return CamelNameUtils.camel2underscore((String)className.substring(className.lastIndexOf(".") + 1));
    }

    public static SqlParamsPairs getUpdateFromObject(Object po) throws Exception {
        StringBuffer updateSql = new StringBuffer();
        StringBuffer whereSql = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        Object idValue = null;
        String tableName = ModelSqlUtils.getTableName(po.getClass());
        updateSql.append("update " + tableName + " set");
        Field[] fields = po.getClass().getDeclaredFields();
        int count = 0;
        for (int i = 0; i < fields.length; ++i) {
            Transient tranAnno;
            Object value;
            Field f = fields[i];
            Method getter = ModelSqlUtils.getGetter(po.getClass(), f);
            if (getter == null || (value = getter.invoke(po, new Object[0])) == null || (tranAnno = getter.getAnnotation(Transient.class)) != null) continue;
            String columnName = ModelSqlUtils.getColumnNameFromGetter(getter, f);
            Id idAnno = getter.getAnnotation(Id.class);
            if (idAnno != null) {
                whereSql.append(columnName + " = ?");
                idValue = value;
                continue;
            }
            params.add(value);
            if (count != 0) {
                updateSql.append(",");
            }
            updateSql.append(" " + columnName + " = ?");
            ++count;
        }
        updateSql.append(" where ");
        updateSql.append(whereSql);
        params.add(idValue);
        SqlParamsPairs sqlAndParams = new SqlParamsPairs(updateSql.toString(), params.toArray());
        logger.debug(sqlAndParams.toString());
        return sqlAndParams;
    }

    public static SqlParamsPairs getDeleteFromObject(Object po) throws Exception {
        StringBuffer deleteSql = new StringBuffer();
        Object idValue = null;
        String tableName = ModelSqlUtils.getTableName(po.getClass());
        deleteSql.append("delete from " + tableName + " where ");
        Class<?> clazz = po.getClass();
        Field[] fields = clazz.getDeclaredFields();
        Id idAnno = null;
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            Method getter = ModelSqlUtils.getGetter(clazz, f);
            if (getter == null || (idAnno = getter.getAnnotation(Id.class)) == null) continue;
            String columnName = ModelSqlUtils.getColumnNameFromGetter(getter, f);
            deleteSql.append(columnName + " = ?");
            idValue = getter.invoke(po, new Object[0]);
            break;
        }
        if (idAnno == null) {
            throw new NoIdAnnotationFoundException(clazz);
        }
        SqlParamsPairs sqlAndParams = new SqlParamsPairs(deleteSql.toString(), new Object[]{idValue});
        logger.debug(sqlAndParams.toString());
        return sqlAndParams;
    }

    public static <T> SqlParamsPairs getGetFromObject(Class<T> clazz, Object id) throws NoIdAnnotationFoundException, NoColumnAnnotationFoundException {
        StringBuffer getSql = new StringBuffer();
        String tableName = ModelSqlUtils.getTableName(clazz);
        getSql.append("select * from " + tableName + " where ");
        Field[] fields = clazz.getDeclaredFields();
        Id idAnno = null;
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            Method getter = ModelSqlUtils.getGetter(clazz, f);
            if (getter == null || (idAnno = getter.getAnnotation(Id.class)) == null) continue;
            String columnName = ModelSqlUtils.getColumnNameFromGetter(getter, f);
            getSql.append(columnName + " = ?");
            break;
        }
        if (idAnno == null) {
            throw new NoIdAnnotationFoundException(clazz);
        }
        SqlParamsPairs sqlAndParams = new SqlParamsPairs(getSql.toString(), new Object[]{id});
        logger.debug(sqlAndParams.toString());
        return sqlAndParams;
    }

    private static String getColumnNameFromGetter(Method getter, Field f) {
        String columnName = "";
        Column columnAnno = getter.getAnnotation(Column.class);
        if (columnAnno != null) {
            columnName = columnAnno.name();
        }
        if (columnName == null || "".equals(columnName)) {
            columnName = CamelNameUtils.camel2underscore((String)f.getName());
        }
        return columnName;
    }
}

