<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="f" uri="http://java.sun.com/jsp/jstl/functions" %>
<jsp:useBean id="it" scope="request" type="org.crazyyak.app.demo.resources.HomePageModel"/>
<html>
  <head>
    <title>Yak Demo App</title>
  </head>
  <body>
    <h1>Yak Demo App</h1>

    <c:if test="${f:length(it.message) > 0}"><div id="err-msg" style="color:red; font-weight:bold; margin-bottom:1em">${it.message}</div></c:if>

    <c:if test="${it.account != null}">
      Go ahead ${it.account.firstName}, you can <a href="<c:url value="/admin"/>">peek</a>.
      <form method="post" action="<c:url value='/sign-out'/>">
        <input type="submit" value="Sign Out"/>
      </form>
    </c:if>

    <c:if test="${it.account == null}">
      <form name="loginForm" action="<c:url value="/sign-in"/>" method="POST">
        <table class="form" style="width:auto">
          <tbody>
            <tr>
              <td><label for="user-name">Username:</label></td>
              <td><input type="text" id="user-name" name="userName" value="yak@example.com"/></td>
            </tr>
            <tr>
              <td><label for="password">Password:</label></td>
              <td><input type="password" id="password" name="password" autocomplete="off" value="Testing123"/></td>
            </tr>
            <tr>
              <td colspan="2" style="text-align: right">
                <input id="submit" name="submit" type="submit" value="Sign In"/>
              </td>
            </tr>
          </tbody>
        </table>
      </form>
    </c:if>

  </body>
</html>