package org.crazyyak.app.demo.internal;

import org.crazyyak.dev.jerseyspring.YakWebAppInitializer;
import org.glassfish.jersey.server.ResourceConfig;
import org.springframework.core.annotation.Order;
import org.springframework.web.context.WebApplicationContext;

import javax.servlet.ServletContext;

// Order required to ensure this initializer is run
// before Jersey 2.x Spring WebApplicationInitializer
@Order(0)
public class DemoWebAppInitializer extends YakWebAppInitializer {

  public DemoWebAppInitializer() {
  }

  @Override
  public Class<? extends ResourceConfig> getApplicationClass(ServletContext servletContext, WebApplicationContext appContext) {
    return DemoApplication.class;
  }

  @Override
  public String getEnvironmentPropertyName(ServletContext servletContext, WebApplicationContext appContext) {
    return "yak.demo.env";
  }

  @Override
  public String getProfilesPropertyName(ServletContext servletContext, WebApplicationContext appContext) {
    return "yak.demo.profiles";
  }

  @Override
  protected String getSpringConfigLocation(ServletContext servletContext, WebApplicationContext appContext) {
    return "classpath:/demo-app/demo-app.xml";
  }
}