/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.app.demo.internal;

import org.crazyyak.app.demo.domain.Account;
import org.crazyyak.app.demo.domain.AccountStore;
import org.crazyyak.dev.common.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.AbstractUserDetailsAuthenticationProvider;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;

@Component
public class DemoSecurityProvider
extends AbstractUserDetailsAuthenticationProvider {
    private final AccountStore accountStore;

    @Autowired
    public DemoSecurityProvider(AccountStore accountStore) {
        this.accountStore = accountStore;
    }

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        if (BeanUtils.objectsNotEqual((Object)userDetails.getUsername(), (Object)authentication.getPrincipal())) {
            throw new UsernameNotFoundException("Invalid user name or password");
        }
        if (BeanUtils.objectsNotEqual((Object)userDetails.getPassword(), (Object)authentication.getCredentials())) {
            throw new BadCredentialsException("Invalid user name or password");
        }
    }

    protected UserDetails retrieveUser(String userName, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        Account account = this.accountStore.getByEmailAddress(userName);
        if (account == null || BeanUtils.objectsNotEqual((Object)account.getEmailAddress(), (Object)userName)) {
            throw new UsernameNotFoundException("Invalid user name or password");
        }
        return account.toUser();
    }
}

