package org.crazyyak.app.demo.resources;

import javax.annotation.Resource;
import javax.servlet.http.*;
import javax.ws.rs.*;
import javax.ws.rs.core.*;
import org.apache.commons.logging.*;
import org.crazyyak.app.demo.domain.Account;
import org.glassfish.jersey.server.mvc.Viewable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.*;
import org.springframework.stereotype.Component;

@Path("/")
@Resource
@Component
public class RootResource implements BeanFactoryAware {

  private static final Log log = LogFactory.getLog(RootResource.class);

  private HttpServletRequest servletRequest;
  private HttpServletResponse servletResponse;
  private SecurityContext securityContext;
  private UriInfo uriInfo;
  private HttpHeaders headers;

  private BeanFactory beanFactory;

  public RootResource() {
    log.info("Root resource loaded.");
  }

  @Context public void setServletRequest(HttpServletRequest servletRequest) {
    this.servletRequest = servletRequest;
  }
  @Context public void setServletResponse(HttpServletResponse servletResponse) {
    this.servletResponse = servletResponse;
  }
  @Context public void setSecurityContext(SecurityContext securityContext) {
    this.securityContext = securityContext;
  }
  @Context public void setUriInfo(UriInfo uriInfo) {
    this.uriInfo = uriInfo;
  }
  @Context public void setHeaders(HttpHeaders headers) {
    this.headers = headers;
  }

  public RequestConfig getRequestConfig() {
    return new RequestConfig(
        beanFactory,
        servletRequest,
        servletResponse,
        uriInfo,
        headers,
        securityContext);
  }

  @GET
  @Produces(MediaType.TEXT_HTML)
  public Viewable getDefaultPage() {
    return renderHomePage(null);
  }

  @GET
  @Path("/signed-out")
  @Produces(MediaType.TEXT_HTML)
  public Viewable getSignedOut() {
    return renderHomePage("You have signed out.");
  }

  @GET
  @Path("/auth-failed")
  @Produces(MediaType.TEXT_HTML)
  public Viewable authenticationFailed() {
    return renderHomePage("You do not have permissions to access this resource.");
  }

  @GET
  @Path("/access-denied")
  @Produces(MediaType.TEXT_HTML)
  public Viewable accessDenied() {
    return renderHomePage("You do not have permissions to access this resource.");
  }

  private Viewable renderHomePage(String message) {
    RequestConfig requestConfig = getRequestConfig();
    Account account = requestConfig.getAccount();
    return new Viewable("/index.jsp", new HomePageModel(account, message));
  }

  @Path("/admin")
  public AdminResource getAdminResource() {
    RequestConfig requestConfig = getRequestConfig();
    return new AdminResource(requestConfig);
  }

  @Path("/api")
  public ApiResource getApiResource() {
    RequestConfig requestConfig = getRequestConfig();
    return new ApiResource(requestConfig);
  }

  @Override
  public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
    this.beanFactory = beanFactory;
  }
}
