package org.crazyyak.app.demo.domain;

import com.fasterxml.jackson.annotation.*;
import java.io.Serializable;

public class AccountStatus implements Serializable {

  private final boolean enabled;
  private final boolean credentialsNonExpired;
  private final boolean accountNonLocked;
  private final boolean accountNonExpired;

  @JsonCreator
  public AccountStatus(@JsonProperty("enabled") boolean enabled,
                       @JsonProperty("credentialsNonExpired") boolean credentialsNonExpired,
                       @JsonProperty("accountNonLocked") boolean accountNonLocked,
                       @JsonProperty("accountNonExpired") boolean accountNonExpired) {

    this.enabled = enabled;
    this.credentialsNonExpired = credentialsNonExpired;
    this.accountNonLocked = accountNonLocked;
    this.accountNonExpired = accountNonExpired;
  }

  public boolean isEnabled() {
    return enabled;
  }

  public boolean isCredentialsNonExpired() {
    return credentialsNonExpired;
  }

  public boolean isAccountNonLocked() {
    return accountNonLocked;
  }

  public boolean isAccountNonExpired() {
    return accountNonExpired;
  }
}
