// Copyright (c) 2010-2013, Munchie Monster, LLC.
package org.crazyyak.app.demo.domain;

import com.couchace.annotations.CouchEntity;
import com.couchace.annotations.CouchId;
import com.couchace.annotations.CouchRevision;
import com.fasterxml.jackson.annotation.*;
import java.util.Set;

@CouchEntity(AccountStore.ACCOUNT_DESIGN_NAME)
public class Account {

  public static final String INVALID_USER_NAME_OR_PASSWORD = "Invalid user name or password";

  private final String accountId;
  private final String revision;

  private String firstName;
  private String lastName;

  private String emailAddress;
  private String password;

  @JsonUnwrapped
  private Permissions permissions;

  private AccountStatus accountStatus;

  @JsonCreator
  public Account(@JacksonInject("accountId") String accountId,
                 @JacksonInject("revision") String revision,
                 @JsonProperty("emailAddress") String emailAddress,
                 @JsonProperty("password") String password,
                 @JsonProperty("firstName") String firstName,
                 @JsonProperty("lastName") String lastName) {

    this.accountId = accountId;
    this.revision = revision;

    this.emailAddress = emailAddress;
    this.password = password;

    this.firstName = firstName;
    this.lastName = lastName;
  }

  @CouchId
  public String getAccountId() {
    return accountId;
  }

  @CouchRevision
  public String getRevision() {
    return revision;
  }

  @JsonIgnore
  public Set<String> getRoleTypes() {
    return permissions.getRoleTypes();
  }

  public String getPassword() {
    return password;
  }

  public Permissions getPermissions() {
    return permissions;
  }

  public AccountStatus getAccountStatus() {
    return accountStatus;
  }

  public String getEmailAddress() {
    return emailAddress;
  }

  public String getFirstName() {
    return firstName;
  }

  public String getLastName() {
    return lastName;
  }

  public CurrentUser toUser() {
    return new CurrentUser(this);
  }

  public boolean equals(Object object) {
    if (object instanceof Account) {
      Account that = (Account)object;
      return this.accountId.equals(that.accountId);
    }
    return false;
  }

  public String toString() {
    return emailAddress;
  }
}
