package org.crazyyak.demo.jerseyspring.resources;

import javax.ws.rs.*;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.crazyyak.demo.jerseyspring.domain.Account;
import org.crazyyak.dev.common.fine.FineMessage;
import org.crazyyak.dev.common.fine.FineMessageSetBuilder;
import org.crazyyak.dev.common.fine.FineMessageSetImpl;
import org.crazyyak.dev.common.fine.TraitMap;
import org.crazyyak.dev.common.json.JsonTranslator;
import org.crazyyak.dev.domain.locality.LatLng;
import org.crazyyak.dev.jackson.YakJacksonTranslator;
import org.crazyyak.dev.jackson.test.FreeBird;
import org.glassfish.jersey.server.mvc.Viewable;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;

public class ApiResource {

  private RequestConfig requestConfig;

  public ApiResource(RequestConfig requestConfig) {
    this.requestConfig = requestConfig;
  }

  @GET
  @Path("/account/{emailAddress}")
  @Consumes(MediaType.APPLICATION_JSON)
  @Produces(MediaType.APPLICATION_JSON)
  public Account getDefault(@PathParam("emailAddress") String emailAddress) {
    return requestConfig.getAccountStore().getByEmailAddress(emailAddress);
  }

  @GET
  @Path("/date/{date}/month-of-year")
  @Produces(MediaType.APPLICATION_JSON)
  public int getCurrentDate(@PathParam("date") LocalDate localDate) {
    return localDate.getMonthOfYear();
  }

  @GET
  @Path("/plain-text")
  @Produces(MediaType.TEXT_PLAIN)
  public String getPlainText() {
    String text = "This is plain text.\n" +
        "There really isn't much to it.\n\n" +
        "\t- One Crazy Yak";
    return text;
  }

  @GET
  @Path("/free-bird")
  @Produces(MediaType.APPLICATION_JSON)
  public FreeBird freeBirdBaby() {

    return new FreeBird(
        "string-value", Long.MAX_VALUE, Integer.MIN_VALUE,
        new LatLng("37.3382030", "-119.7085060"),
        new org.crazyyak.dev.domain.money.Money("19.95"),
        org.joda.money.Money.parse("USD 99.99"),
        new LocalTime("12:32:13"), new LocalDate("1975-05-06"), new LocalDateTime("1975-05-06T12:32:13"),
        new TraitMap("first:yes", "empty-value:", "null-value", "last:ok"),
        FineMessage.withText("This message is fine!"),
        (FineMessageSetImpl) new FineMessageSetBuilder()
            .withText("Hi, my name is Joe!")
            .withTraits("I'm Suzie", "girl:true", "boy:false").build());
  }
}
